/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.sys.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.sys.converter.sys.SysRoleConverter;
import cn.smarthse.rho.modules.sys.dao.sys.SysRoleMapper;
import cn.smarthse.rho.modules.sys.dao.sys.SysUserRoleMapper;
import cn.smarthse.rho.modules.sys.entity.sys.SysRole;
import cn.smarthse.rho.modules.sys.entity.sys.SysUserRole;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysRoleVo;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserRoleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SysUserRoleServiceImpl
extends ServiceImpl<SysUserRoleMapper, SysUserRole>
implements ISysUserRoleService {
    private final SysRoleConverter converter;
    private final SysRoleMapper sysRoleMapper;

    @Override
    public Set<String> selectRolePermissionByUserId(Long userId) {
        return ((SysUserRoleMapper)this.baseMapper).selectRolePermissionByUserId(userId);
    }

    @Override
    public List<SysRoleVo> getRoleListByUserId(Long userId) {
        if (Objects.isNull(userId)) {
            return Collections.emptyList();
        }
        return ((SysUserRoleMapper)this.baseMapper).selectRoleListByUserId(userId);
    }

    @Override
    public List<SysRoleVo> getSelectedRoleListByUserId(Long userId) {
        List sysRoleList = this.sysRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(SysRole.class).eq(SysRole::getIsSys, (Object)Constant.TRUE)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).ne(SysRole::getId, (Object)100));
        if (CollUtil.isEmpty((Collection)sysRoleList)) {
            return Collections.emptyList();
        }
        List<SysRoleVo> rst = this.converter.sysRoleList2SysRoleVoList(sysRoleList);
        return rst.stream().sorted(Comparator.comparing(SysRoleVo::getRoleId)).collect(Collectors.toList());
    }

    public SysUserRoleServiceImpl(SysRoleConverter converter, SysRoleMapper sysRoleMapper) {
        this.converter = converter;
        this.sysRoleMapper = sysRoleMapper;
    }
}

