/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.sys.impl;

import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.sys.converter.sys.SysConverter;
import cn.smarthse.rho.modules.sys.dao.sys.SysSettingTableMapper;
import cn.smarthse.rho.modules.sys.entity.sys.SysSettingTable;
import cn.smarthse.rho.modules.sys.model.sys.param.SysSettingTableEditParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysSettingTableVo;
import cn.smarthse.rho.modules.sys.service.sys.ISysSettingTableService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysSettingTableServiceImpl
extends ServiceImpl<SysSettingTableMapper, SysSettingTable>
implements ISysSettingTableService {
    private final SysConverter converter;

    @Override
    @Cacheable(value={"settingTable=24"}, key="#userId +':'+ #tableCode", unless="#result == null", condition="#userId != null")
    public SysSettingTableVo getSettingTable(Long userId, String tableCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(SysSettingTable.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysSettingTable::getUserId, (Object)userId)).eq(SysSettingTable::getTableCode, (Object)tableCode)).last("limit 1");
        SysSettingTable record = (SysSettingTable)this.getOne((Wrapper)wrapper);
        return this.converter.sysSettingTable2SysSettingTableVo(record);
    }

    @Override
    @CacheEvict(value={"settingTable"}, key="#param.loginUserId +':'+ #param.tableCode")
    @Transactional
    public void saveSettingTable(SysSettingTableEditParam param) {
        SysSettingTableVo exists = this.getSettingTable(param.getLoginUserId(), param.getTableCode());
        if (exists == null) {
            SysSettingTable record = this.converter.sysSettingTableEditParam2SysSettingTable(param);
            this.save(record);
        } else {
            SysSettingTable record = this.converter.sysSettingTableEditParam2SysSettingTable(param);
            record.setId(exists.getId());
            this.updateById(record);
        }
    }

    public SysSettingTableServiceImpl(SysConverter converter) {
        this.converter = converter;
    }
}

