/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.sys.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.mybatis.SysChangeLog;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.rho.modules.sys.dao.sys.SysChangeLogMapper;
import cn.smarthse.rho.modules.sys.enums.company.BusinessStatusEnum;
import cn.smarthse.rho.modules.sys.enums.company.CompanyStateEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysChangeLogEnum;
import cn.smarthse.rho.modules.sys.model.sys.param.SysChangeLogListParam;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.rho.modules.sys.service.sys.ISysChangeLogService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class SysChangeLogServiceImpl
extends ServiceImpl<SysChangeLogMapper, SysChangeLog>
implements ISysChangeLogService {
    private final ISysAreaService sysAreaService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;

    @Override
    public List<SysChangeLog> getChangeLogList(Long dataId, String tableName) {
        return this.getChangeLogList(dataId, tableName, null);
    }

    @Override
    public Page<SysChangeLog> getChangeLogList(SysChangeLogListParam param) {
        Page rst;
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        if (param.getTableName().equalsIgnoreCase("b_company")) {
            List<SysChangeLog> list;
            if (Objects.isNull(param.getLevel())) {
                param.setLevel(this.sysAreaService.getLevel(param.getAreaId()));
            }
            if (CollUtil.isNotEmpty(list = ((SysChangeLogMapper)this.baseMapper).getCompanyChangeLogList(param))) {
                HashSet areaIds = CollUtil.newHashSet((Object[])new Long[0]);
                HashSet supervisionUnitIds = CollUtil.newHashSet((Object[])new Long[0]);
                list.forEach(i -> {
                    if (SysChangeLogEnum.company_area_id.getColumn().equalsIgnoreCase(i.getFieldValue())) {
                        if (!"null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getBeforeValue()))) {
                            areaIds.add(Long.parseLong(i.getBeforeValue()));
                        }
                        if (!"null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getAfterValue()))) {
                            areaIds.add(Long.parseLong(i.getAfterValue()));
                        }
                    } else if (SysChangeLogEnum.company_supervision_unit.getColumn().equalsIgnoreCase(i.getFieldValue())) {
                        if (!"null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getBeforeValue()))) {
                            supervisionUnitIds.add(Long.parseLong(i.getBeforeValue()));
                        }
                        if (!"null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getAfterValue()))) {
                            supervisionUnitIds.add(Long.parseLong(i.getAfterValue()));
                        }
                    }
                });
                Map areaIdMap = this.sysAreaProvideService.getAreaMapByIdList(new ArrayList(areaIds));
                Map supervisionUnitMap = this.organizationService.getOrgMapByIdList((Set)supervisionUnitIds);
                list.stream().peek(i -> {
                    switch (i.getFieldValue()) {
                        case "state": {
                            if (!"null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getBeforeValue()))) {
                                i.setBeforeValue(CompanyStateEnum.getNameByValue((Integer)Integer.parseInt(i.getBeforeValue())));
                            }
                            if ("null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getAfterValue()))) break;
                            i.setAfterValue(CompanyStateEnum.getNameByValue((Integer)Integer.parseInt(i.getAfterValue())));
                            break;
                        }
                        case "business_status": {
                            if (!"null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getBeforeValue()))) {
                                i.setBeforeValue(BusinessStatusEnum.getNameByValue((Integer)Integer.parseInt(i.getBeforeValue())));
                            }
                            if ("null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getAfterValue()))) break;
                            i.setAfterValue(BusinessStatusEnum.getNameByValue((Integer)Integer.parseInt(i.getAfterValue())));
                            break;
                        }
                        case "area_id": {
                            if (!"null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getBeforeValue()))) {
                                Optional.ofNullable(areaIdMap.get(Long.parseLong(i.getBeforeValue()))).ifPresent(a -> i.setBeforeValue(a.getFullname()));
                            }
                            if ("null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getAfterValue()))) break;
                            Optional.ofNullable(areaIdMap.get(Long.parseLong(i.getAfterValue()))).ifPresent(a -> i.setAfterValue(a.getFullname()));
                            break;
                        }
                        case "belong_type": {
                            if (!"null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getBeforeValue()))) {
                                i.setBeforeValue(CompanyBelongTypeEnum.getNameByValue((Integer)Integer.parseInt(i.getBeforeValue())));
                            }
                            if ("null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getAfterValue()))) break;
                            i.setAfterValue(CompanyBelongTypeEnum.getNameByValue((Integer)Integer.parseInt(i.getAfterValue())));
                            break;
                        }
                        case "supervision_unit": {
                            if (!"null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getBeforeValue()))) {
                                Optional.ofNullable(supervisionUnitMap.get(Long.parseLong(i.getBeforeValue()))).ifPresent(o -> i.setBeforeValue(o.getName()));
                            }
                            if ("null".equalsIgnoreCase(StrUtil.trimToNull((CharSequence)i.getAfterValue()))) break;
                            Optional.ofNullable(supervisionUnitMap.get(Long.parseLong(i.getAfterValue()))).ifPresent(o -> i.setAfterValue(o.getName()));
                            break;
                        }
                    }
                }).collect(Collectors.toList());
            }
            rst = (Page)list;
        } else if (param.getTableName().equalsIgnoreCase("sys_user")) {
            if (Objects.isNull(param.getLevel())) {
                param.setLevel(this.sysAreaService.getLevel(param.getAreaId()));
            }
            List<SysChangeLog> list = ((SysChangeLogMapper)this.baseMapper).getSysUserChangeLogList(param);
            rst = (Page)list;
        } else {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(SysChangeLog.class);
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(Objects.nonNull(param.getDataId()), SysChangeLog::getDataId, (Object)param.getDataId())).eq(SysChangeLog::getTableName, (Object)param.getTableName())).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).eq(StrUtil.isNotBlank((CharSequence)param.getKeyword()), SysChangeLog::getUsername, (Object)param.getKeyword())).orderByDesc(SysChangeLog::getId);
            wrapper.select(new SFunction[]{SysChangeLog::getUserId, SysChangeLog::getUsername, SysChangeLog::getTableName, SysChangeLog::getDataId, SysChangeLog::getOperation, SysChangeLog::getFieldName, SysChangeLog::getFieldValue, SysChangeLog::getBeforeValue, SysChangeLog::getAfterValue, SysChangeLog::getContent, SysChangeLog::getEditTime, SysChangeLog::getBatchCode});
            rst = (Page)this.list((Wrapper)wrapper);
        }
        return rst;
    }

    @Override
    public List<SysChangeLog> getChangeLogList(Long dataId, String tableName, String fieldValue) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(SysChangeLog.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysChangeLog::getDataId, (Object)dataId)).eq(SysChangeLog::getTableName, (Object)tableName)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES);
        if (fieldValue != null) {
            wrapper.eq(SysChangeLog::getFieldValue, (Object)fieldValue);
        }
        wrapper.select(new SFunction[]{SysChangeLog::getUserId, SysChangeLog::getUsername, SysChangeLog::getTableName, SysChangeLog::getDataId, SysChangeLog::getOperation, SysChangeLog::getFieldName, SysChangeLog::getFieldValue, SysChangeLog::getBeforeValue, SysChangeLog::getAfterValue, SysChangeLog::getContent, SysChangeLog::getEditTime, SysChangeLog::getBatchCode});
        return ((SysChangeLogMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<SysChangeLog> getMultiFieldChangeLogList(Long dataId, String tableName, List<String> fieldValues) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(SysChangeLog.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysChangeLog::getDataId, (Object)dataId)).eq(SysChangeLog::getTableName, (Object)tableName)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES);
        if (CollectionUtil.isNotEmpty(fieldValues)) {
            wrapper.in(SysChangeLog::getFieldValue, fieldValues);
        }
        wrapper.select(new SFunction[]{SysChangeLog::getUserId, SysChangeLog::getUsername, SysChangeLog::getTableName, SysChangeLog::getDataId, SysChangeLog::getOperation, SysChangeLog::getFieldName, SysChangeLog::getFieldValue, SysChangeLog::getBeforeValue, SysChangeLog::getAfterValue, SysChangeLog::getContent, SysChangeLog::getEditTime, SysChangeLog::getBatchCode});
        return ((SysChangeLogMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public SysChangeLogServiceImpl(ISysAreaService sysAreaService) {
        this.sysAreaService = sysAreaService;
    }
}

