/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.sys.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.core.framework.utils.SpringContextHolder;
import cn.smarthse.rho.modules.sys.converter.sys.SysConverter;
import cn.smarthse.rho.modules.sys.dao.sys.SysAreaMapper;
import cn.smarthse.rho.modules.sys.entity.sys.SysArea;
import cn.smarthse.rho.modules.sys.model.sys.param.SysAreaParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaTreeVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class SysAreaServiceImpl
extends ServiceImpl<SysAreaMapper, SysArea>
implements ISysAreaService {
    private final SysConverter sysConverter;

    @Override
    @Cacheable(value={"area=24"}, key="#areaId", unless="#result == null", condition="#areaId != null")
    public SysAreaVo getAreaById(Long areaId) {
        if (areaId == null) {
            return null;
        }
        return this.sysConverter.area2SysAreaVo((SysArea)this.getById(areaId));
    }

    @Override
    public String getAreaNameById(Long areaId) {
        SysArea area = (SysArea)((SysAreaServiceImpl)SpringContextHolder.getBean(this.getClass())).getById(areaId);
        return area != null ? area.getName() : null;
    }

    @Override
    public List<SysAreaVo> getAreaList(Long pid) {
        pid = pid == null ? 0L : pid;
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"parent_id", (Object)pid)).eq((Object)"is_valid", (Object)Constant.ACTIVE_YES)).select((Object[])new String[]{"id", "parent_id", "name", "level", "province_id", "province_name", "city_id", "city_name", "area_id", "area_name", "street_id", "street_name", "lng", "lat"});
        List<SysAreaVo> rst = this.sysConverter.area2SysAreaVo(this.list(queryWrapper));
        Map<Long, List<SysAreaVo>> map = this.getAreaMapByPidList(rst.stream().map(SysAreaVo::getId).collect(Collectors.toList()));
        rst.stream().peek(i -> i.setIsLeaf(Boolean.valueOf(!map.containsKey(i.getId())))).collect(Collectors.toList());
        return rst;
    }

    @Override
    public List<SysAreaTreeVo> getAreaTreeList(Long pid) {
        if (pid == null) {
            pid = 0L;
            SysAreaVo sysArea = ((SysAreaServiceImpl)SpringContextHolder.getBean(this.getClass())).getAreaById(pid);
            SysAreaTreeVo sysAreaTreeDto = new SysAreaTreeVo();
            sysAreaTreeDto.setId(sysArea.getId());
            sysAreaTreeDto.setName(sysArea.getName());
            sysAreaTreeDto.setIsParent(Boolean.valueOf(sysArea.getLevel() != 4));
            sysAreaTreeDto.setParentId(sysArea.getParentId());
            sysAreaTreeDto.setAreaLevel(sysArea.getLevel());
            return Collections.singletonList(sysAreaTreeDto);
        }
        return ((SysAreaMapper)this.baseMapper).getAreaTreeList(pid);
    }

    @Override
    public String getAreaAddress(Long areaId, String linkCode) {
        if (areaId == null) {
            return "";
        }
        SysAreaVo sysArea = ((SysAreaServiceImpl)SpringContextHolder.getBean(this.getClass())).getAreaById(areaId);
        if (sysArea == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (sysArea.getLevel() >= 1) {
            result.append(sysArea.getProvinceName());
        }
        if (sysArea.getLevel() >= 2) {
            result.append(linkCode).append(sysArea.getCityName());
        }
        if (sysArea.getLevel() >= 3) {
            result.append(linkCode).append(sysArea.getAreaName());
        }
        if (sysArea.getLevel() >= 4) {
            result.append(linkCode).append(sysArea.getStreetName());
        }
        return result.toString();
    }

    @Override
    public String getAreaAddress(Long areaId) {
        return this.getAreaAddress(areaId, ">");
    }

    @Override
    public Map<String, Long> getByAreaAddress(List<String> areaAddressList) {
        HashMap<String, Long> map = new HashMap<String, Long>(areaAddressList.size());
        areaAddressList.forEach(record -> map.put((String)record, this.getByAreaAddress((String)record)));
        return map;
    }

    @Override
    public Long getByAreaAddress(String areaAddress) {
        String[] split = areaAddress.split(">");
        int length = split.length;
        SysArea area = null;
        if (length == 1) {
            area = this.getAreaByName(split[0]);
        }
        if (length == 2) {
            area = this.getAreaByName(split[0], split[1]);
        }
        if (length == 3) {
            area = this.getAreaByName(split[0], split[1], split[2]);
        }
        if (length == 4) {
            area = this.getAreaByName(split[0], split[1], split[2], split[3]);
        }
        return area != null ? area.getId() : null;
    }

    @Override
    public Integer getLevel(Long areaId) {
        SysAreaVo area = ((SysAreaServiceImpl)SpringContextHolder.getBean(this.getClass())).getAreaById(areaId);
        return area == null ? null : area.getLevel();
    }

    @Override
    public boolean hasPermission(Long childAreaId, Long parentId) {
        if (childAreaId == null || parentId == 0L) {
            return true;
        }
        SysAreaVo area = ((SysAreaServiceImpl)SpringContextHolder.getBean(this.getClass())).getAreaById(childAreaId);
        return area == null || parentId != null && (parentId.equals(area.getProvinceId()) || parentId.equals(area.getCityId()) || parentId.equals(area.getAreaId()) || parentId.equals(area.getStreetId()));
    }

    @Override
    public List<SysAreaVo> getSubAreaByIdAndLevel(Long areaId, Integer level) {
        return ((SysAreaMapper)this.baseMapper).getSubAreaByIdAndLevel(areaId, level);
    }

    @Override
    public Map<Long, SysAreaVo> getAreaMapByIdList(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return Collections.emptyMap();
        }
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().in((Object)"id", idList)).eq((Object)"is_valid", (Object)Constant.ACTIVE_YES)).select((Object[])new String[]{"id", "parent_id", "name", "level", "province_id", "province_name", "city_id", "city_name", "area_id", "area_name", "street_id", "street_name", "lng", "lat"});
        List sysAreaList = this.list(queryWrapper);
        if (CollUtil.isEmpty((Collection)sysAreaList)) {
            return Collections.emptyMap();
        }
        List<SysAreaVo> list = this.sysConverter.area2SysAreaVo(sysAreaList);
        return list.stream().collect(Collectors.toMap(SysAreaVo::getId, item -> item, (v1, v2) -> v1));
    }

    @Override
    public Map<Long, List<SysAreaVo>> getAreaMapByPidList(List<Long> pidList) {
        if (CollUtil.isEmpty(pidList)) {
            return Collections.emptyMap();
        }
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().in((Object)"parent_id", pidList)).eq((Object)"is_valid", (Object)Constant.ACTIVE_YES)).select((Object[])new String[]{"id", "parent_id", "name", "level", "province_id", "province_name", "city_id", "city_name", "area_id", "area_name", "street_id", "street_name", "lng", "lat"});
        List sysAreaList = this.list(queryWrapper);
        if (CollUtil.isEmpty((Collection)sysAreaList)) {
            return Collections.emptyMap();
        }
        List<SysAreaVo> list = this.sysConverter.area2SysAreaVo(sysAreaList);
        return list.stream().collect(Collectors.groupingBy(SysAreaVo::getParentId));
    }

    @Override
    public SysArea getByNameAndLevel(SysAreaParam areaParam) {
        return ((SysAreaMapper)this.baseMapper).getByNameAndLevel(areaParam);
    }

    private SysArea getAreaByName(String provinceName) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"province_name", (Object)provinceName)).eq((Object)"is_valid", (Object)Constant.ACTIVE_YES)).select((Object[])new String[]{"id", "pid", "name", "level", "province_id", "province_name"});
        return (SysArea)this.getOne(queryWrapper);
    }

    private SysArea getAreaByName(String provinceName, String cityName) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"province_name", (Object)provinceName)).eq((Object)"name", (Object)cityName)).eq((Object)"is_valid", (Object)Constant.ACTIVE_YES)).select((Object[])new String[]{"id", "pid", "name", "level", "province_id", "province_name", "city_id", "city_name"});
        SysArea area = (SysArea)this.getOne(queryWrapper);
        return area != null ? area : this.getAreaByName(provinceName);
    }

    private SysArea getAreaByName(String provinceName, String cityName, String areaName) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"province_name", (Object)provinceName)).eq((Object)"city_name", (Object)cityName)).eq((Object)"name", (Object)areaName)).eq((Object)"is_valid", (Object)Constant.ACTIVE_YES)).select((Object[])new String[]{"id", "pid", "name", "level", "province_id", "province_name", "city_id", "city_name", "area_id", "area_name"});
        SysArea area = (SysArea)this.getOne(queryWrapper);
        return area != null ? area : this.getAreaByName(provinceName, cityName);
    }

    private SysArea getAreaByName(String provinceName, String cityName, String areaName, String streetName) {
        Wrapper queryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"province_name", (Object)provinceName)).eq((Object)"city_name", (Object)cityName)).eq((Object)"area_name", (Object)areaName)).eq((Object)"name", (Object)streetName)).eq((Object)"is_valid", (Object)Constant.ACTIVE_YES)).select((Object[])new String[]{"id", "pid", "name", "level", "province_id", "province_name", "city_id", "city_name", "area_id", "area_name", "street_id", "street_name"});
        SysArea area = (SysArea)this.getOne(queryWrapper);
        return area != null ? area : this.getAreaByName(provinceName, cityName, areaName);
    }

    public SysAreaServiceImpl(SysConverter sysConverter) {
        this.sysConverter = sysConverter;
    }
}

