/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.c.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.sys.dao.c.CTrainingCertMapper;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.model.c.param.StaffCertChooseListParam;
import cn.smarthse.rho.modules.sys.model.c.param.TrainingCertSyncParam;
import cn.smarthse.rho.modules.sys.model.c.param.TrainingRelationshipParam;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffCertChooseListVo;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.r.vo.CalculateVo;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskGenVo;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.utils.risk.WarningTypeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CTrainingCertServiceImpl
extends ServiceImpl<CTrainingCertMapper, CTrainingCert>
implements ICTrainingCertService {
    @Autowired
    private ICStaffBaseInfoService staffBaseInfoService;
    @Autowired
    private ICStaffService staffService;

    @Override
    @Transactional
    public String rmTrainingCert(TrainingCertSyncParam param) {
        if (param.getSourceEnrollId() == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(CTrainingCert::getSourceEnrollId, (Object)param.getSourceEnrollId());
        this.remove((Wrapper)wrapper);
        return null;
    }

    @Override
    public CTrainingCert getInfoBySourceCertId(Long sourceCertId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(CTrainingCert::getSourceCertId, (Object)sourceCertId)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (CTrainingCert)this.getOne((Wrapper)wrapper);
    }

    @Override
    public List<RiskGenVo> getTrainingPreRisk(RiskMangerGenParam param) {
        return ((CTrainingCertMapper)this.baseMapper).getTrainingPreRisk(param);
    }

    @Override
    public CTrainingCert getLastTrainingCheckData(Long staffBaseInfoId) {
        return ((CTrainingCertMapper)this.baseMapper).getLastTrainingCheckData(staffBaseInfoId);
    }

    @Override
    public CTrainingCert getLastValidData(Long staffBaseInfoId) {
        return ((CTrainingCertMapper)this.baseMapper).getLastValidData(staffBaseInfoId);
    }

    @Override
    @Transactional
    public void addRelatedRelationships(TrainingRelationshipParam param) {
        Long staffBaseInfoId = param.getStaffBaseInfoId();
        List trainingCertIdList = param.getTrainingCertIdList();
        if (staffBaseInfoId == null || CollUtil.isEmpty((Collection)trainingCertIdList)) {
            throw new ServiceException("\u7f3a\u5c11\u76f8\u5173\u4fe1\u606f");
        }
        ArrayList<CTrainingCert> result = new ArrayList<CTrainingCert>();
        for (Long certId : trainingCertIdList) {
            CTrainingCert cert = (CTrainingCert)this.getById(certId);
            CStaffBaseInfo staffBaseInfo = (CStaffBaseInfo)this.staffBaseInfoService.getById(staffBaseInfoId);
            CStaff staff = this.staffService.getInfo(staffBaseInfoId, cert.getCid());
            CTrainingCertServiceImpl.checkTRParam(cert, staffBaseInfo, staff);
            CTrainingCert entity = new CTrainingCert();
            entity.setId(cert.getId());
            entity.setStaffBaseInfoId(staffBaseInfo.getId());
            result.add(entity);
        }
        this.updateBatchById(result);
    }

    private static void checkTRParam(CTrainingCert cert, CStaffBaseInfo staffBaseInfo, CStaff staff) {
        if (cert == null) {
            throw new ServiceException("\u7f3a\u5c11\u8bc1\u6570\u4fe1\u606f");
        }
        if (staffBaseInfo == null || staff == null) {
            throw new ServiceException("\u7f3a\u5c11\u4eba\u5458\u4fe1\u606f");
        }
        if (cert.getStaffBaseInfoId() != null) {
            throw new ServiceException("\u8bc1\u4e66\u5df2\u88ab\u5176\u4ed6\u4eba\u5458\u7ed1\u5b9a");
        }
        if (StrUtil.isBlank((CharSequence)staffBaseInfo.getIdcard())) {
            throw new ServiceException("\u4eba\u5458\u7f3a\u5c11\u8bc1\u4ef6\u53f7");
        }
        if (StrUtil.isBlank((CharSequence)cert.getIdcard())) {
            throw new ServiceException("\u8bc1\u6570\u7f3a\u5c11\u8bc1\u4ef6\u53f7");
        }
        if (cert.getCid() == null) {
            throw new ServiceException("\u8bc1\u6570\u7f3a\u5c11\u516c\u53f8\u4fe1\u606f");
        }
        if (cert.getCid() == null || staff.getCid() == null || !cert.getCid().equals(staff.getCid())) {
            throw new ServiceException("\u8bc1\u4e66\u533b\u9662\u4fe1\u606f\u4e0e\u4eba\u5458\u516c\u53f8\u4fe1\u606f\u4e0d\u7b26");
        }
    }

    @Override
    public LayuiGridData<StaffCertChooseListVo> getStaffCertChooseList(StaffCertChooseListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffCertChooseListVo> list = ((CTrainingCertMapper)this.baseMapper).getStaffCertChooseList(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public CalculateVo calculate(CTrainingCert entity) {
        if (entity.getIssuanceDate() == null) {
            return null;
        }
        if (entity.getCertValidDate() == null) {
            return null;
        }
        CalculateVo calculate = new CalculateVo();
        calculate.setStartTime(LocalDateTimeUtil.of((TemporalAccessor)entity.getIssuanceDate()));
        calculate.setExpireTime(LocalDateTimeUtil.of((TemporalAccessor)entity.getCertValidDate()));
        calculate.setWarningType(this.calculateWarnType(entity));
        return calculate;
    }

    @Override
    public CalculateVo calculate2(CStaffBaseInfo entity) {
        if (entity.getCreateDate() == null) {
            return null;
        }
        CalculateVo calculate = new CalculateVo();
        calculate.setStartTime(entity.getCreateDate());
        calculate.setWarningType(WarningTypeUtil.calculateNonDataWarningType((LocalDateTime)entity.getCreateDate()));
        return calculate;
    }

    private Integer calculateWarnType(CTrainingCert entity) {
        if (entity.getCertValidDate() == null) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime expireDate = LocalDateTimeUtil.of((TemporalAccessor)entity.getCertValidDate());
        return WarningTypeUtil.calculateHasDataWarningType((LocalDateTime)now, (LocalDateTime)expireDate);
    }
}

