/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.c.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.core.framework.utils.RhoIdCardUtil;
import cn.smarthse.rho.modules.sys.converter.c.CStaffBaseInfoConverter;
import cn.smarthse.rho.modules.sys.dao.c.CStaffBaseInfoMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.b.BOrg;
import cn.smarthse.rho.modules.sys.entity.b.BPost;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoRangeVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoSyncVo;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffInfoRangeParam;
import cn.smarthse.rho.modules.sys.model.c.param.CertStaffChooseListParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffChangeLogParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffSelectInfoParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CertStaffChooseListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChangeLogVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffSelectInfo;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.b.IBOrgService;
import cn.smarthse.rho.modules.sys.service.b.IBPostService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.sys.ISysParamService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CStaffBaseInfoServiceImpl
extends ServiceImpl<CStaffBaseInfoMapper, CStaffBaseInfo>
implements ICStaffBaseInfoService {
    @Autowired
    private CStaffBaseInfoConverter staffBaseInfoConverter;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IBOrgService orgService;
    @Autowired
    private IBPostService postService;
    @Autowired
    private ISysParamService paramService;
    @Autowired
    private ICStaffService staffService;

    @Override
    public CStaffBaseInfo getByIdCard(String idCard) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(CStaffBaseInfo::getIdcard, (Object)idCard)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (CStaffBaseInfo)this.getOne((Wrapper)wrapper);
    }

    @Override
    public StaffSelectInfo getSelectInfoForAdding(StaffSelectInfoParam param) {
        String name;
        String idCard = param.getIdCard();
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{idCard, name = param.getName()})) {
            throw new ServiceException("\u4fe1\u606f\u4e0d\u5339\u914d");
        }
        CStaffBaseInfo db = this.getByIdCard(idCard);
        if (db == null) {
            return null;
        }
        if (StrUtil.equals((CharSequence)db.getName(), (CharSequence)param.getName())) {
            throw new ServiceException("\u4fe1\u606f\u4e0d\u5339\u914d");
        }
        StaffSelectInfo result = new StaffSelectInfo();
        boolean validCard = IdcardUtil.isValidCard((String)idCard);
        result.setId(db.getId());
        result.setName(db.getName());
        result.setPhone(db.getPhone());
        result.setIdcardType(db.getIdcardType());
        result.setIdcard(db.getIdcard());
        result.setSex(Integer.valueOf(validCard ? IdcardUtil.getGenderByIdCard((String)idCard) : result.getSex()));
        result.setAge(Integer.valueOf(validCard ? IdcardUtil.getAgeByIdCard((String)idCard) : result.getAge()));
        result.setBirthday(validCard ? IdcardUtil.getBirthDate((String)idCard).toLocalDateTime().toLocalDate() : result.getBirthday());
        return result;
    }

    @Override
    public List<Long> getCidList(Long staffBaseInfoId, Integer postStatus, Integer staffType) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getCidList(staffBaseInfoId, postStatus, staffType);
    }

    @Override
    public LayuiGridData<StaffChangeLogVo> getStaffChangeLog(StaffChangeLogParam param) {
        if (CollUtil.isEmpty((Collection)param.getDataIds()) || CollUtil.isEmpty((Collection)param.getFieldValues()) || CollUtil.isEmpty((Collection)param.getTableNames())) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffChangeLogVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getStaffChangeLog(param);
        for (StaffChangeLogVo vo : list) {
            this.translateChangeLog(vo);
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    private void translateChangeLog(StaffChangeLogVo vo) {
        String beforeValue = vo.getBeforeValue();
        String afterValue = vo.getAfterValue();
        beforeValue = StrUtil.isBlank((CharSequence)beforeValue) || StrUtil.equals((CharSequence)beforeValue, (CharSequence)"null") ? null : beforeValue;
        afterValue = StrUtil.isBlank((CharSequence)afterValue) || StrUtil.equals((CharSequence)afterValue, (CharSequence)"null") ? null : afterValue;
        String fieldName = vo.getFieldValue();
        String beforeTranslateValue = null;
        String afterTranslateValue = null;
        boolean isNumeric1 = StrUtil.isNumeric((CharSequence)beforeValue);
        boolean isNumeric2 = StrUtil.isNumeric((CharSequence)afterValue);
        if ("cid".equals(fieldName)) {
            BCompany company1 = null;
            BCompany company2 = null;
            if (isNumeric1) {
                company1 = this.companyService.getByIdIncludeDel(beforeValue);
            }
            if (isNumeric2) {
                company2 = this.companyService.getByIdIncludeDel(afterValue);
            }
            beforeTranslateValue = company1 == null ? null : company1.getName();
            afterTranslateValue = company2 == null ? null : company2.getName();
        } else if ("org_id".equals(fieldName)) {
            BOrg org1 = null;
            BOrg org2 = null;
            if (isNumeric1) {
                org1 = this.orgService.getByIdIncludeDel(Long.valueOf(beforeValue));
            }
            if (isNumeric2) {
                org2 = this.orgService.getByIdIncludeDel(Long.valueOf(afterValue));
            }
            beforeTranslateValue = org1 == null ? null : org1.getName();
            afterTranslateValue = org2 == null ? null : org2.getName();
        } else if ("post_status".equals(fieldName)) {
            if (isNumeric1) {
                beforeTranslateValue = PostStatusEnum.getName((Integer)Integer.valueOf(beforeValue));
            }
            if (isNumeric2) {
                afterTranslateValue = PostStatusEnum.getName((Integer)Integer.valueOf(afterValue));
            }
        } else if ("post".equals(fieldName)) {
            BPost post;
            if (isNumeric1) {
                post = (BPost)this.postService.getById(Long.valueOf(beforeValue));
                String string = beforeTranslateValue = post == null ? null : post.getName();
            }
            if (isNumeric2) {
                post = (BPost)this.postService.getById(Long.valueOf(afterValue));
                afterTranslateValue = post == null ? null : post.getName();
            }
        } else if ("sex".equals(fieldName)) {
            beforeTranslateValue = "0".equals(beforeValue) ? "\u5973" : "\u7537";
            afterTranslateValue = "0".equals(beforeValue) ? "\u5973" : "\u7537";
        } else if ("staff_type".equals(fieldName)) {
            if (StrUtil.isNotBlank((CharSequence)beforeValue)) {
                String string = beforeTranslateValue = "0".equals(beforeValue) ? "\u975e\u653e\u5c04\u5de5\u4f5c\u4eba\u5458" : "\u653e\u5c04\u5de5\u4f5c\u4eba\u5458";
            }
            if (StrUtil.isNotBlank((CharSequence)afterValue)) {
                afterTranslateValue = "0".equals(afterValue) ? "\u975e\u653e\u5c04\u5de5\u4f5c\u4eba\u5458" : "\u653e\u5c04\u5de5\u4f5c\u4eba\u5458";
            }
        } else if ("if_ra_manager".equals(fieldName)) {
            beforeTranslateValue = StrUtil.equals((CharSequence)beforeValue, (CharSequence)"0") ? "\u975e\u653e\u5c04\u536b\u751f\u9632\u62a4\u7ba1\u7406\u4eba\u5458" : "\u653e\u5c04\u536b\u751f\u9632\u62a4\u7ba1\u7406\u4eba\u5458";
            afterTranslateValue = StrUtil.equals((CharSequence)afterValue, (CharSequence)"0") ? "\u975e\u653e\u5c04\u536b\u751f\u9632\u62a4\u7ba1\u7406\u4eba\u5458" : "\u653e\u5c04\u536b\u751f\u9632\u62a4\u7ba1\u7406\u4eba\u5458";
        } else {
            beforeTranslateValue = vo.getBeforeValue();
            afterTranslateValue = vo.getAfterTranslateValue();
        }
        vo.setBeforeTranslateValue(beforeTranslateValue);
        vo.setAfterTranslateValue(afterTranslateValue);
        if (fieldName.equals("name")) {
            vo.setBeforeTranslateValue(DesensitizedUtil.desensitized((CharSequence)beforeTranslateValue, (DesensitizedUtil.DesensitizedType)DesensitizedUtil.DesensitizedType.CHINESE_NAME));
            vo.setAfterTranslateValue(DesensitizedUtil.desensitized((CharSequence)afterTranslateValue, (DesensitizedUtil.DesensitizedType)DesensitizedUtil.DesensitizedType.CHINESE_NAME));
            vo.setBeforeValue(vo.getBeforeTranslateValue());
            vo.setAfterValue(vo.getAfterTranslateValue());
        } else if (fieldName.equals("phone")) {
            vo.setBeforeTranslateValue(DesensitizedUtil.desensitized((CharSequence)beforeTranslateValue, (DesensitizedUtil.DesensitizedType)DesensitizedUtil.DesensitizedType.MOBILE_PHONE));
            vo.setAfterTranslateValue(DesensitizedUtil.desensitized((CharSequence)afterTranslateValue, (DesensitizedUtil.DesensitizedType)DesensitizedUtil.DesensitizedType.MOBILE_PHONE));
            vo.setBeforeValue(vo.getBeforeTranslateValue());
            vo.setAfterValue(vo.getAfterTranslateValue());
        } else if (fieldName.equals("idcard")) {
            vo.setBeforeTranslateValue(RhoIdCardUtil.desensitizeIdCard((String)beforeTranslateValue));
            vo.setAfterTranslateValue(RhoIdCardUtil.desensitizeIdCard((String)afterTranslateValue));
            vo.setBeforeValue(vo.getBeforeTranslateValue());
            vo.setAfterValue(vo.getAfterTranslateValue());
        }
        vo.setContent(null);
    }

    @Override
    public LayuiGridData<CertStaffChooseListVo> getCertStaffChooseList(CertStaffChooseListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CertStaffChooseListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getCertStaffChooseList(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public boolean hasIdCardConflict(Long id, String idCard) {
        if (StrUtil.isEmpty((CharSequence)idCard)) {
            return false;
        }
        CStaffBaseInfo entity = this.getOneByIdCard(idCard);
        return entity != null && !entity.getId().equals(id);
    }

    @Override
    public CStaffBaseInfo getOneByIdCard(String idCard) {
        if (StrUtil.isBlank((CharSequence)idCard)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(CStaffBaseInfo::getIdcard, (Object)idCard)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (CStaffBaseInfo)this.getOne((Wrapper)wrapper);
    }

    @Override
    public List<CStaffInfoSyncVo> getWandaSyncInfoFromCHData(WandaSyncParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getWandaSyncInfoFromCHData(param);
    }

    @Override
    public List<CStaffInfoSyncVo> getWandaSyncInfoFromDoseData(WandaSyncParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getWandaSyncInfoFromDoseData(param);
    }

    @Override
    public List<CStaffInfoSyncVo> getWandaSyncInfoFromTrainingData(WandaSyncParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getWandaSyncInfoFromTrainingData(param);
    }

    @Override
    public List<CStaffInfoSyncVo> getWandaSyncStaffInfoFromCHData(WandaSyncParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getWandaSyncStaffInfoFromCHData(param);
    }

    @Override
    public List<CStaffInfoSyncVo> getWandaSyncStaffInfoFromDoseData(WandaSyncParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getWandaSyncStaffInfoFromDoseData(param);
    }

    @Override
    public List<CStaffInfoSyncVo> getWandaSyncStaffInfoFromTrainingData(WandaSyncParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getWandaSyncStaffInfoFromTrainingData(param);
    }

    @Override
    public CStaffInfoRangeVo getStaffInfoRangeForCompany(CStaffInfoRangeParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getStaffInfoRangeForCompany(param);
    }

    @Override
    public CStaffInfoRangeVo getStaffInfoRangeForAdmin(CStaffInfoRangeParam param) {
        if (param.getLevel() == null || param.getAreaId() == null) {
            throw new ServiceException("\u7f3a\u5931\u533a\u57df\u6570\u636e");
        }
        return ((CStaffBaseInfoMapper)this.baseMapper).getStaffInfoRangeForAdmin(param);
    }

    @Override
    @Transactional
    public void establishStaffCmContactFromHc(WandaSyncParam param) {
        ((CStaffBaseInfoMapper)this.baseMapper).establishStaffCmContactFromHc(param);
    }

    @Override
    @Transactional
    public void establishStaffCmContactFromDose(WandaSyncParam param) {
        ((CStaffBaseInfoMapper)this.baseMapper).establishStaffCmContactFromDose(param);
    }

    @Override
    @Transactional
    public void establishStaffCmContactFromTrainingCert(WandaSyncParam param) {
        ((CStaffBaseInfoMapper)this.baseMapper).establishStaffCmContactFromTrainingCert(param);
    }

    @Override
    @Transactional
    public void insertStaffBaseInfoFromHC(WandaSyncParam wandaSyncParam) {
        ((CStaffBaseInfoMapper)this.baseMapper).insertStaffBaseInfoFromHC(wandaSyncParam);
    }

    @Override
    @Transactional
    public void insertStaffBaseInfoFromDose(WandaSyncParam wandaSyncParam) {
        ((CStaffBaseInfoMapper)this.baseMapper).insertStaffBaseInfoFromDose(wandaSyncParam);
    }

    @Override
    @Transactional
    public void insertStaffBaseInfoFromTraining(WandaSyncParam wandaSyncParam) {
        ((CStaffBaseInfoMapper)this.baseMapper).insertStaffBaseInfoFromTraining(wandaSyncParam);
    }

    @Override
    public void dealViceDataRelation(WandaSyncParam param) {
        ((CStaffBaseInfoMapper)this.baseMapper).dealViceDataRelation(param);
    }

    @Override
    public List<CStaffBaseInfo> getListForGenHcRisk(RiskMangerGenParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getListForGenRisk(param);
    }

    @Override
    public List<CStaffBaseInfo> getListForGenTrainingRisk(RiskMangerGenParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getListForGenTrainingRisk(param);
    }

    @Override
    public List<CStaffBaseInfo> getListForGenDoseRisk(RiskMangerGenParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getListForGenDoseRisk(param);
    }
}

