/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.c.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.sys.dao.c.CHealthCheckDataMapper;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.RhoRiskCycleEnum;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.r.vo.CalculateVo;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskGenVo;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaHealthDataSyncParam;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.utils.risk.WarningTypeUtil;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CHealthCheckDataServiceImpl
extends ServiceImpl<CHealthCheckDataMapper, CHealthCheckData>
implements ICHealthCheckDataService {
    @Override
    public List<RiskGenVo> getHealthCheckPreRisk(RiskMangerGenParam param) {
        return ((CHealthCheckDataMapper)this.baseMapper).getHealthCheckPreRisk(param);
    }

    @Override
    public CHealthCheckData getLastHealthCheckData(Long staffBaseInfoId) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastHealthCheckData(staffBaseInfoId);
    }

    @Override
    public CHealthCheckData getLastValidData(Long staffBaseInfoId) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastValidData(staffBaseInfoId);
    }

    @Override
    @Transactional
    public void dealHealthCheckStaffRelation(WandaSyncParam param) {
        ((CHealthCheckDataMapper)this.baseMapper).dealHealthCheckStaffRelation(param);
    }

    @Override
    @Transactional
    public void dealCompanyRelation(WandaHealthDataSyncParam param) {
        ((CHealthCheckDataMapper)this.baseMapper).dealCompanyRelation(param);
    }

    @Override
    public CalculateVo calculate(CHealthCheckData lastData) {
        if (lastData.getCheckDate() == null) {
            return null;
        }
        LocalDateTime expireDate = this.calculateExpireDate(lastData);
        LocalDateTime startDate = LocalDateTimeUtil.of((TemporalAccessor)lastData.getCheckDate());
        Integer warnType = this.calculateWarnType(lastData);
        CalculateVo calculate = new CalculateVo();
        calculate.setWarningType(warnType);
        calculate.setExpireTime(expireDate);
        calculate.setStartTime(startDate);
        return calculate;
    }

    @Override
    public CalculateVo calculate2(CStaffBaseInfo entity) {
        if (entity == null) {
            return null;
        }
        if (entity.getCreateDate() == null) {
            return null;
        }
        CalculateVo calculate = new CalculateVo();
        calculate.setWarningType(WarningTypeUtil.calculateNonDataWarningType((LocalDateTime)entity.getCreateDate()));
        calculate.setExpireTime(null);
        calculate.setStartTime(entity.getCreateDate());
        return calculate;
    }

    private Integer calculateWarnType(CHealthCheckData lastData) {
        if (lastData.getCheckDate() == null) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime expireDate = this.calculateExpireDate(lastData);
        return WarningTypeUtil.calculateHasDataWarningType((LocalDateTime)now, (LocalDateTime)expireDate);
    }

    private LocalDateTime calculateExpireDate(CHealthCheckData lastData) {
        if (lastData.getCheckDate() == null) {
            return null;
        }
        return LocalDateTimeUtil.offset((LocalDateTime)LocalDateTimeUtil.of((TemporalAccessor)lastData.getCheckDate()), (long)RhoRiskCycleEnum.HC.getCycle(), (TemporalUnit)RhoRiskCycleEnum.HC.getUnit());
    }
}

