/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.c.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.sys.dao.c.CDoseDataMapper;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.RhoRiskCycleEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.r.vo.CalculateVo;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskGenVo;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.utils.risk.WarningTypeUtil;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CDoseDataServiceImpl
extends ServiceImpl<CDoseDataMapper, CDoseData>
implements ICDoseDataService {
    @Override
    public List<RiskGenVo> getDosePreRisk(RiskMangerGenParam param) {
        return ((CDoseDataMapper)this.baseMapper).getDosePreRisk(param);
    }

    @Override
    public CDoseData getLastDoseCheckData(Long staffBaseInfoId) {
        return ((CDoseDataMapper)this.baseMapper).getLastDoseCheckData(staffBaseInfoId);
    }

    @Override
    public CDoseData getLastValidData(Long staffBaseInfoId) {
        return ((CDoseDataMapper)this.baseMapper).getLastValidData(staffBaseInfoId);
    }

    @Override
    public CalculateVo calculate(CDoseData entity) {
        if (entity.getCheckDate() == null) {
            return null;
        }
        LocalDateTime startDate = LocalDateTimeUtil.of((TemporalAccessor)entity.getCheckDate());
        LocalDateTime expireDate = this.calculateExpireDate(entity);
        Integer warnType = this.calculateWarnType(entity);
        CalculateVo calculate = new CalculateVo();
        calculate.setWarningType(warnType);
        calculate.setExpireTime(expireDate);
        calculate.setStartTime(startDate);
        return calculate;
    }

    @Override
    public CalculateVo calculate2(CStaffBaseInfo entity) {
        if (entity.getCreateDate() == null) {
            return null;
        }
        CalculateVo calculate = new CalculateVo();
        calculate.setStartTime(entity.getCreateDate());
        Integer warningType = WarningTypeUtil.calculateNonDataWarningType((LocalDateTime)entity.getCreateDate());
        warningType = warningType.equals(RiskWarningStatusEnum.RED.getValue()) || warningType.equals(RiskWarningStatusEnum.ACTIVATE_LAW.getValue()) ? warningType : RiskWarningStatusEnum.NONE.getValue();
        calculate.setWarningType(warningType);
        return calculate;
    }

    private Integer calculateWarnType(CDoseData entity) {
        if (entity.getCheckDate() == null) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime expireDate = this.calculateExpireDate(entity);
        return WarningTypeUtil.calculateHasDataWarningTypeForDose((LocalDateTime)now, (LocalDateTime)expireDate);
    }

    private LocalDateTime calculateExpireDate(CDoseData entity) {
        if (entity.getCheckDate() == null) {
            return null;
        }
        return LocalDateTimeUtil.offset((LocalDateTime)LocalDateTimeUtil.of((TemporalAccessor)entity.getCheckDate()), (long)RhoRiskCycleEnum.DOSE.getCycle(), (TemporalUnit)RhoRiskCycleEnum.DOSE.getUnit());
    }
}

