/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.rho.modules.sys.dao.b.BCompanyMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.enums.company.BusinessStatusEnum;
import cn.smarthse.rho.modules.sys.model.b.param.CompanySyncParam;
import cn.smarthse.rho.modules.sys.model.b.param.hse.training.RhoCompanyUserPageParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CompanySyncFswsHospitalInfoVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CompanySyncVo;
import cn.smarthse.rho.modules.sys.model.b.vo.hse.training.RhoCompanyHseTrainingVo;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.sys.param.BCompanyChooseListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyStatueEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserBusinessStatueEditParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.BCompanyChooseVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysCompanyListVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysCompanyOneVo;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BCompanyServiceImpl
extends ServiceImpl<BCompanyMapper, BCompany>
implements IBCompanyService {
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @Override
    public Boolean isHasBelongTypeComByAreaId(Long areaId) {
        if (areaId == null) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38");
        }
        Byte level = this.sysAreaProvideService.getAreaByIdV3(areaId).getLevel();
        if (level > 2) {
            return false;
        }
        return ((BCompanyMapper)this.baseMapper).getBelongTypeComCountsByAreaId(areaId, level) > 0L;
    }

    @Override
    public PageInfo<BCompanyVo> getListForZLB(SysCompanyListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<BCompanyVo> list = ((BCompanyMapper)this.baseMapper).getListForZLB(param);
        return new PageInfo(list);
    }

    @Override
    public PageInfo<BCompanyChooseVo> getChooseList(BCompanyChooseListParam param) {
        List list;
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<BCompanyChooseVo> rst = ((BCompanyMapper)this.baseMapper).getChooseList(param);
        if (Objects.equals(param.getQueryChildren(), Boolean.TRUE) && CollUtil.isNotEmpty(rst) && CollUtil.isNotEmpty((Collection)(list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BCompany::getCreditCode, (Collection)rst.stream().map(BCompanyChooseVo::getCreditCode).collect(Collectors.toList()))).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).select(new SFunction[]{BCompany::getId, BCompany::getName, BCompany::getCreditCode, BCompany::getHospitalName}))))) {
            Map map = list.stream().collect(Collectors.groupingBy(BCompany::getCreditCode, Collectors.mapping(bCompany -> new BCompanyChooseVo().setId(bCompany.getId()).setName(bCompany.getName()).setCreditCode(bCompany.getCreditCode()).setHospitalName(bCompany.getHospitalName()), Collectors.toList())));
            for (BCompanyChooseVo dto : rst) {
                dto.getChildren().addAll(map.getOrDefault(dto.getCreditCode(), Collections.emptyList()));
            }
        }
        return new PageInfo(rst);
    }

    @Override
    public PageInfo<SysCompanyListVo> getSysCompanyListData(SysCompanyListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<SysCompanyListVo> list = ((BCompanyMapper)this.baseMapper).getSysCompanyListData(param);
        return new PageInfo(list);
    }

    @Override
    public SysCompanyOneVo getSysCompany(Long cid) {
        return ((BCompanyMapper)this.baseMapper).getSysCompany(cid);
    }

    @Override
    @Transactional
    public Boolean updateSysCompany(SysCompanyEditParam param) {
        BCompany exists = (BCompany)this.getById(param.getBranchCid());
        if (Objects.isNull(exists)) {
            throw new ServiceException("\u8be5\u9662\u533a\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        if (this.isHaveThisBranchName(param.getBranchName(), param.getBranchCid()).booleanValue()) {
            throw new ServiceException("\u8be5\u9662\u533a\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        if (this.isHaveThisMedicalNucode(param.getMedicalNucode(), param.getBranchCid()).booleanValue()) {
            throw new ServiceException("\u8be5\u552f\u4e00\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BCompany::getCreditCode, (Object)exists.getCreditCode())).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES));
        ArrayList<BCompany> updateList = new ArrayList<BCompany>(list.size());
        for (BCompany company : list) {
            BCompany dto = new BCompany();
            dto.setId(company.getId());
            if (Objects.equals(param.getBranchCid(), company.getId())) {
                dto.setName(param.getBranchName());
                dto.setMedicalNucode(StrUtil.isBlank((CharSequence)param.getMedicalNucode()) ? "" : param.getMedicalNucode());
            }
            dto.setHospitalName(param.getHospitalName());
            dto.setUpdateBy(param.getLoginUserId());
            dto.setUpdateDate(LocalDateTime.now());
            updateList.add(dto);
        }
        return this.updateBatchById(updateList);
    }

    @Override
    public Boolean isHaveThisBranchName(String branchName, Long excludeId) {
        return this.exists((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BCompany::getName, (Object)branchName)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).ne(Objects.nonNull(excludeId), BCompany::getId, (Object)excludeId));
    }

    @Override
    public Boolean isHaveThisMedicalNucode(String medicalNucode, Long excludeId) {
        return this.exists((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BCompany::getMedicalNucode, (Object)medicalNucode)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).ne(Objects.nonNull(excludeId), BCompany::getId, (Object)excludeId));
    }

    @Override
    @Transactional
    public Boolean updateSysCompanyStatue(SysCompanyStatueEditParam param) {
        BCompany exists = (BCompany)this.getById(param.getBranchCid());
        if (exists == null) {
            throw new ServiceException("\u8be5\u9662\u533a\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        BCompany record = new BCompany();
        record.setId(param.getBranchCid());
        record.setState(param.getState());
        record.setUpdateBy(param.getLoginUserId());
        record.setUpdateDate(LocalDateTime.now());
        return this.updateById(record);
    }

    @Override
    @Transactional
    public Boolean updateSysCompanyIsMain(SysCompanyStatueEditParam param) {
        BCompany exists = (BCompany)this.getById(param.getBranchCid());
        if (exists == null) {
            throw new ServiceException("\u8be5\u9662\u533a\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        int isMain = param.getState();
        ArrayList<BCompany> updateList = new ArrayList<BCompany>();
        BCompany record = new BCompany();
        record.setId(param.getBranchCid());
        record.setIsMain(Integer.valueOf(isMain));
        record.setUpdateBy(param.getLoginUserId());
        record.setUpdateDate(LocalDateTime.now());
        record.setMainId(isMain == 1 ? exists.getId() : null);
        record.setMainName(isMain == 1 ? exists.getName() : null);
        updateList.add(record);
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BCompany::getCreditCode, (Object)exists.getCreditCode())).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).ne(BCompany::getId, (Object)exists.getId()));
        if (CollUtil.isNotEmpty((Collection)list)) {
            for (BCompany company : list) {
                company.setUpdateBy(param.getLoginUserId());
                company.setUpdateDate(LocalDateTime.now());
                company.setIsMain(Integer.valueOf(0));
                company.setMainId(isMain == 1 ? record.getMainId() : null);
                company.setMainName(isMain == 1 ? record.getMainName() : null);
                updateList.add(company);
            }
        }
        return ((BCompanyMapper)this.baseMapper).updateSysCompanyIsMain(updateList);
    }

    @Override
    @Transactional
    public Boolean updateSysCompanyBusinessStatue(SysCompanyUserBusinessStatueEditParam param) {
        BCompany exists = (BCompany)this.getById(param.getCid());
        if (exists == null) {
            throw new ServiceException("\u8be5\u9662\u533a\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        BCompany record = new BCompany();
        record.setId(param.getCid());
        record.setBusinessStatus(param.getBusinessStatus());
        record.setUpdateBy(param.getLoginUserId());
        record.setUpdateDate(LocalDateTime.now());
        return this.updateById(record);
    }

    @Override
    public BCompany getByMedicalNucode(String medicalNucode) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(BCompany::getMedicalNucode, (Object)medicalNucode)).last("limit 1");
        return (BCompany)this.getOne((Wrapper)wrapper);
    }

    @Override
    public BCompany getNewestWandaCompanyInfo(String medicalNucode) {
        return ((BCompanyMapper)this.baseMapper).getNewestWandaCompanyInfo(medicalNucode);
    }

    @Override
    public List<CompanySyncVo> getWandaSyncInfo(CompanySyncParam param) {
        return ((BCompanyMapper)this.baseMapper).getWandaSyncInfo(param);
    }

    @Override
    public List<BCompany> getNeedRegisterAccountForWanda(CompanySyncParam param) {
        return ((BCompanyMapper)this.baseMapper).getNeedRegisterAccountForWanda(param);
    }

    @Override
    public void initHospitalName(CompanySyncParam param) {
        ((BCompanyMapper)this.baseMapper).initHospitalName(param);
    }

    @Override
    public List<String> getCreditCodeFromWanda(CompanySyncParam param) {
        return ((BCompanyMapper)this.baseMapper).getCreditCodeFromWanda(param);
    }

    @Override
    public BCompany getByCreditCodeAndName(String creditCode, String name) {
        return ((BCompanyMapper)this.baseMapper).getByCreditCodeAndName(creditCode, name);
    }

    @Override
    public List<CompanySyncFswsHospitalInfoVo> getNeedAddBaseInfoFromWandaFswsHospitalInfoTable(CompanySyncParam param) {
        return ((BCompanyMapper)this.baseMapper).getNeedAddBaseInfoFromWandaFswsHospitalInfoTable(param);
    }

    @Override
    public BCompany getByRhoHospitalIdIncludeDel(String rhoHospitalId) {
        return ((BCompanyMapper)this.baseMapper).getByRhoHospitalIdIncludeDel(rhoHospitalId);
    }

    @Override
    public BCompany getByName(String name) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(BCompany::getName, (Object)name)).last("limit 1");
        return (BCompany)this.getOne((Wrapper)wrapper);
    }

    @Override
    public BCompany getNewestByNameIncludeDel(String name) {
        return ((BCompanyMapper)this.baseMapper).getNewestByNameIncludeDel(name);
    }

    @Override
    public BCompany getByMedicalNucodeIncludeDel(String medicalNucode) {
        return ((BCompanyMapper)this.baseMapper).getByMedicalNucodeIncludeDel(medicalNucode);
    }

    @Override
    public List<BCompany> getListForGenRisk(RiskMangerGenParam param) {
        return ((BCompanyMapper)this.baseMapper).getListForGenRisk(param);
    }

    @Override
    public LayuiGridData<RhoCompanyHseTrainingVo> getRhoUserListForHseTrainingAdmin(RhoCompanyUserPageParam param) {
        if (param.getUserAreaId() == null || param.getUserAreaLevel() == null) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u8be2");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RhoCompanyHseTrainingVo> list = ((BCompanyMapper)this.baseMapper).getRhoUserListForHseTrainingAdmin(param);
        for (RhoCompanyHseTrainingVo vo : list) {
            vo.setBusinessStateName(BusinessStatusEnum.getNameByValue((Integer)vo.getBusinessState()));
            vo.setVirtuallyDataSource(Integer.valueOf(0));
            vo.setVirtuallyDataSourceName("\u653e\u5c04\u536b\u751f\u5728\u7ebf");
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public BCompany getByIdIncludeDel(String id) {
        return ((BCompanyMapper)this.baseMapper).getByIdIncludeDel(id);
    }

    @Override
    public boolean isSameHospital(Long targetCid, Long sourceCid) {
        if (targetCid == null) {
            return false;
        }
        List<Long> list = this.getBranchListByCid(sourceCid);
        list = list.stream().filter(v -> targetCid.equals(v)).collect(Collectors.toList());
        return CollUtil.isNotEmpty(list);
    }

    @Override
    public List<Long> getBranchListByCid(Long cid) {
        return ((BCompanyMapper)this.baseMapper).getBranchListByCid(cid);
    }
}

