/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.core.framework.utils.ChangeLicenseUtil;
import cn.smarthse.rho.modules.sys.converter.BChangeLicenseConverter;
import cn.smarthse.rho.modules.sys.dao.b.BChangeLicenseMapper;
import cn.smarthse.rho.modules.sys.entity.b.BChangeLicense;
import cn.smarthse.rho.modules.sys.enums.license.AdminLicenseStatusEnum;
import cn.smarthse.rho.modules.sys.enums.license.LicenseChangeTypeEnum;
import cn.smarthse.rho.modules.sys.model.b.param.license.BChangeLicenseGenParam;
import cn.smarthse.rho.modules.sys.model.b.param.license.ChangeLicenseParam;
import cn.smarthse.rho.modules.sys.model.b.vo.license.ChangeLicenseListVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysCommonProvider;
import cn.smarthse.rho.modules.sys.service.b.IBChangeLicenseService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BChangeLicenseServiceImpl
extends ServiceImpl<BChangeLicenseMapper, BChangeLicense>
implements IBChangeLicenseService {
    @Autowired
    private BChangeLicenseConverter converter;
    @Autowired
    private IBCompanyService companyService;
    @DubboReference
    private ISysCommonProvider sysCommonProvider;

    @Override
    public void applyChange(BChangeLicenseGenParam param) {
        this.genChangeLicense(param);
    }

    @Override
    @Transactional
    public void genChangeLicense(BChangeLicenseGenParam param) {
        BChangeLicense db = this.getByCidAndSubType(param.getCid(), param.getSubType());
        if (db != null) {
            throw new ServiceException("\u4e0d\u53ef\u91cd\u590d\u7533\u8bf7");
        }
        LicenseChangeTypeEnum changeTypeEnum = LicenseChangeTypeEnum.getEnumBySubType((String)param.getSubType());
        BChangeLicense e = new BChangeLicense();
        e.setCid(param.getCid());
        e.setType(changeTypeEnum.getType());
        e.setSubType(changeTypeEnum.getSubType());
        e.setTitle(null);
        e.setTargetId(param.getTargetId());
        e.setBeforeValue(ChangeLicenseUtil.genValue((List)param.getBeforeValueList()));
        e.setAfterValue(ChangeLicenseUtil.genValue((List)param.getAfterValueList()));
        e.setAdminLicenseStatus(param.getNeedLicense() == 1 ? AdminLicenseStatusEnum.NOT_PERMITTED.getStatus() : AdminLicenseStatusEnum.NO_REQUIRED.getStatus());
        e.setNeedLicense(param.getNeedLicense());
        this.save(e);
    }

    @Override
    public BChangeLicense getByCidAndSubType(Long cid, String subType) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(BChangeLicense::getCid, (Object)cid)).eq(BChangeLicense::getSubType, (Object)subType)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (BChangeLicense)this.getOne((Wrapper)wrapper);
    }

    @Override
    public void genChangeLicense(List<BChangeLicenseGenParam> paramList) {
        for (BChangeLicenseGenParam param : paramList) {
            this.genChangeLicense(param);
        }
    }

    @Override
    public LayuiGridData<ChangeLicenseListVo> getChangeLicenseList(ChangeLicenseParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<ChangeLicenseListVo> list = ((BChangeLicenseMapper)this.baseMapper).getChangeLicenseList(param);
        for (ChangeLicenseListVo vo : list) {
            vo.setBeforeValueList(ChangeLicenseUtil.genValueList((String)vo.getBeforeValue()));
            vo.setAfterValueList(ChangeLicenseUtil.genValueList((String)vo.getAfterValue()));
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }
}

