/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.b.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.sys.dao.b.BCertMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCert;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.enums.company.CompanyCertCycleEnum;
import cn.smarthse.rho.modules.sys.model.r.param.CompanyCertTimeUpdateParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.r.vo.CalculateVo;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskGenVo;
import cn.smarthse.rho.modules.sys.service.b.IBCertService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.b.IBLicenseManagementSettingService;
import cn.smarthse.rho.modules.sys.utils.risk.WarningTypeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BCertServiceImpl
extends ServiceImpl<BCertMapper, BCert>
implements IBCertService {
    @Autowired
    private IBLicenseManagementSettingService licenseManagementSettingService;
    @Autowired
    private IBCompanyService companyService;

    @Override
    public List<RiskGenVo> getDataPreRisk(RiskMangerGenParam param) {
        return ((BCertMapper)this.baseMapper).getDataPreRisk(param);
    }

    @Override
    public Boolean isValidDataCert(Long cid) {
        Boolean valid = ((BCertMapper)this.baseMapper).isValidDataCert(cid);
        return valid != null;
    }

    @Override
    public BCert getByCid(Long cid) {
        return ((BCertMapper)this.baseMapper).getByCid(cid);
    }

    @Override
    public BCert getByMedicalNucode(String medicalNucode) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(BCert::getMedicalNucode, (Object)medicalNucode)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (BCert)this.getOne((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void updateNextVerificationDateLock(CompanyCertTimeUpdateParam param) {
        ((BCertMapper)this.baseMapper).updateNextVerificationDateLock(param);
    }

    @Override
    public CalculateVo calculate(BCert cert) {
        if (cert.getBeginDate() == null) {
            return null;
        }
        if (cert.getCid() == null) {
            return null;
        }
        BCompany company = (BCompany)this.companyService.getById(cert.getCid());
        if (company == null) {
            return null;
        }
        Integer cycleYear = BCertServiceImpl.calculateCycleYear(company);
        if (cycleYear == null) {
            return null;
        }
        Integer pushType = this.licenseManagementSettingService.getPushTypeForSup(company.getAreaId());
        if (pushType == null) {
            return null;
        }
        Integer warnType = this.calculateWarnType(cert, company, pushType);
        LocalDateTime expireDate = this.calculateExpireDate(cert, company, pushType);
        LocalDateTime startDate = this.calculateStartDate(cert, company, pushType);
        CalculateVo calculate = new CalculateVo();
        calculate.setWarningType(warnType);
        calculate.setExpireTime(expireDate);
        calculate.setStartTime(startDate);
        return calculate;
    }

    @Override
    public CalculateVo calculate2(BCompany company) {
        if (company.getCreateDate() == null) {
            return null;
        }
        CalculateVo calculate = new CalculateVo();
        calculate.setStartTime(company.getCreateDate());
        calculate.setWarningType(WarningTypeUtil.calculateNonDataWarningType((LocalDateTime)company.getCreateDate()));
        return calculate;
    }

    @Override
    public List<BCert> getListForGenRisk(RiskMangerGenParam param) {
        return ((BCertMapper)this.baseMapper).getListForGenRisk(param);
    }

    @Override
    public List<BCompany> getNonCertCompanyListForGenRisk(RiskMangerGenParam param) {
        return ((BCertMapper)this.baseMapper).getNonCertCompanyListForGenRisk(param);
    }

    private static Integer calculateCycleYear(BCompany company) {
        return CompanyCertCycleEnum.getCycle((String)String.valueOf(company.getType()), (Integer)company.getFloorNum());
    }

    private LocalDateTime calculateStartDate(BCert cert, BCompany company, Integer pushType) {
        Integer cycleYear = BCertServiceImpl.calculateCycleYear(company);
        if (cycleYear == null) {
            return null;
        }
        LocalDateTime beginDate = cert.getBeginDate();
        LocalDateTime lastVerificationDate = cert.getLastVerificationDate() == null ? beginDate : cert.getLastVerificationDate();
        LocalDateTime startTime = pushType == 1 ? beginDate : lastVerificationDate;
        int diffYear = LocalDateTime.now().getYear() - cert.getBeginDate().getYear();
        if (diffYear < 0) {
            return null;
        }
        int l1 = diffYear / cycleYear;
        int l2 = diffYear % cycleYear;
        int multiple = l2 > 0 ? l1 + 1 : l1;
        multiple = multiple > 0 ? multiple - 1 : 0;
        LocalDateTime verifyTime = LocalDateTimeUtil.offset((LocalDateTime)startTime, (long)(cycleYear * multiple), (TemporalUnit)ChronoUnit.YEARS);
        return verifyTime;
    }

    private Integer calculateWarnType(BCert cert, BCompany company, int pushType) {
        LocalDateTime expireDate = this.calculateExpireDate(cert, company, pushType);
        LocalDateTime now = LocalDateTime.now();
        Integer cycleYear = BCertServiceImpl.calculateCycleYear(company);
        if (cycleYear == null) {
            return null;
        }
        return WarningTypeUtil.calculateHasDataWarningTypeForCompanyCert((LocalDateTime)now, (LocalDateTime)expireDate, (Integer)cycleYear);
    }

    private LocalDateTime calculateExpireDate(BCert cert, BCompany company, int pushType) {
        Integer cycleYear = BCertServiceImpl.calculateCycleYear(company);
        if (cycleYear == null) {
            return null;
        }
        LocalDateTime beginDate = cert.getBeginDate();
        LocalDateTime lastVerificationDate = cert.getLastVerificationDate() == null ? beginDate : cert.getLastVerificationDate();
        LocalDateTime startTime = pushType == 1 ? beginDate : lastVerificationDate;
        int diffYear = LocalDateTime.now().getYear() - cert.getBeginDate().getYear();
        if (diffYear < 0) {
            return null;
        }
        long l1 = diffYear / cycleYear;
        long l2 = diffYear % cycleYear;
        long multiple = l2 > 0L ? l1 + 1L : l1;
        LocalDateTime verifyTime = LocalDateTimeUtil.offset((LocalDateTime)startTime, (long)((long)cycleYear.intValue() * multiple), (TemporalUnit)ChronoUnit.YEARS);
        return verifyTime;
    }
}

