/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.provider.zlb;

import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.rho.modules.sys.provider.zlb.IZwddServiceService;
import cn.smarthse.rho.modules.sys.provider.zlb.ZwddUserInfo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.xxpt.gateway.shared.client.http.ExecutableClient;
import com.alibaba.xxpt.gateway.shared.client.http.GetClient;
import com.alibaba.xxpt.gateway.shared.client.http.PostClient;
import java.time.Duration;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DubboService
public class ZwddServiceService
implements IZwddServiceService {
    private static final Logger log = LoggerFactory.getLogger(ZwddServiceService.class);
    private static final String gettoken = "/gettoken.json";
    private static final String get_by_mobile = "/mozi/employee/get_by_mobile";
    private static final String dingtalk_app_user = "/rpc/oauth2/dingtalk_app_user.json";
    private static final String accessToken = "login:accessToken";
    private ExecutableClient executableClient;

    public ZwddServiceService(SysProperties sysProperties) {
        this.executableClient(sysProperties.getZwdd());
    }

    private void executableClient(SysProperties.Zwdd zwdd) {
        log.info("\u914d\u7f6e executableClient\uff1a {}", (Object)zwdd.getDomainName());
        ExecutableClient executableClient = ExecutableClient.getInstance();
        executableClient.setAccessKey(zwdd.getAccessKey());
        executableClient.setSecretKey(zwdd.getSecretKey());
        executableClient.setDomainName(zwdd.getDomainName());
        executableClient.setProtocal(zwdd.getProtocal());
        executableClient.init();
        this.executableClient = executableClient;
    }

    public ZwddUserInfo getUserInfo(String code) {
        String accessToken = this.getAccessToken();
        String userInfo = this.getUserInfo(accessToken, code);
        return this.getZwddUserInfo(userInfo);
    }

    private String getAccessToken() {
        JSONObject content;
        String cache = (String)RedisUtils.getCacheObject((String)accessToken);
        if (cache != null) {
            return cache;
        }
        GetClient getClient = this.executableClient.newGetClient(gettoken);
        String apiResult = getClient.get();
        log.debug("dingDingLogin::\u83b7\u53d6accessToken\u7ed3\u679c:{}", (Object)apiResult);
        JSONObject jsonObject = JSON.parseObject((String)apiResult);
        Boolean success = jsonObject.getBoolean("success");
        if (Boolean.TRUE.equals(success) && Boolean.TRUE.equals(success = (content = jsonObject.getJSONObject("content")).getBoolean("success"))) {
            String result = content.getJSONObject("data").getString("accessToken");
            RedisUtils.setCacheObject((String)accessToken, (Object)result, (Duration)Duration.ofMinutes(50L));
            return result;
        }
        return null;
    }

    private String getUserInfo(String accessToken, String code) {
        PostClient postClient = this.executableClient.newPostClient(dingtalk_app_user);
        postClient.addParameter("access_token", accessToken);
        postClient.addParameter("code", code);
        String apiResult = postClient.post();
        log.info("dingDingLogin::\u9489\u9489\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7ed3\u679c:{}", (Object)apiResult);
        return apiResult;
    }

    private ZwddUserInfo getZwddUserInfo(String userInfoJson) {
        JSONObject jsonObject = JSON.parseObject((String)userInfoJson);
        Boolean success = jsonObject.getBoolean("success");
        if (Boolean.TRUE.equals(success)) {
            JSONObject content = jsonObject.getJSONObject("content");
            success = content.getBoolean("success");
            if (Boolean.TRUE.equals(success)) {
                return (ZwddUserInfo)content.getJSONObject("data").toJavaObject(ZwddUserInfo.class);
            }
            log.error("\u6d59\u653f\u9489\u63a5\u53e3:getZwddUserInfo:\u5931\u8d25:{}", (Object)content.getString("responseMessage"));
            return null;
        }
        return null;
    }
}

