/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.provider.zlb;

import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.utils.zlb.HmacAuthUtil;
import cn.smarthse.rho.modules.sys.provider.zlb.IZlbClientServiceService;
import cn.smarthse.rho.modules.sys.provider.zlb.ZlbUserInfo;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@DubboService
public class ZlbClientServiceService
implements IZlbClientServiceService {
    private static final Logger log = LoggerFactory.getLogger(ZlbClientServiceService.class);
    private static final String access_token = "/restapi/prod/IC33000020220329000007/uc/sso/access_token";
    private static final String getUserInfo = "/restapi/prod/IC33000020220329000008/uc/sso/getUserInfo";
    private final RestTemplate restTemplate;
    private final SysProperties sysProperties;

    public String getClientTicketCode(String ticketId, String appKey, String appSecret, String appId) {
        String url = this.sysProperties.getZlb().getHost() + access_token;
        Map header = HmacAuthUtil.generateHeader((String)url, (String)"POST", (String)appKey, (String)appSecret);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("ticketId", ticketId);
        params.put("appId", appId);
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u7968\u636e\u8ba4\u8bc1\u8bf7\u6c42start\uff1a{}", (Object)ticketId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAll(header);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)new HttpEntity(params, (MultiValueMap)headers), String.class, new Object[0]);
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u7968\u636e\u8ba4\u8bc1\u8bf7\u6c42end\uff1a{}", forEntity.getBody());
        JSONObject resultJson = JSONObject.parseObject((String)((String)forEntity.getBody()));
        if (((Boolean)resultJson.get((Object)"success")).booleanValue()) {
            return ((JSONObject)resultJson.get((Object)"data")).getString("accessToken");
        }
        return null;
    }

    public ZlbUserInfo getClientInfoByToken(String token, String appKey, String appSecret) {
        String url = this.sysProperties.getZlb().getHost() + getUserInfo;
        Map header = HmacAuthUtil.generateHeader((String)url, (String)"POST", (String)appKey, (String)appSecret);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("token", token);
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u6839\u636e\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606fstart\uff1a{}", (Object)token);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAll(header);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)new HttpEntity(params, (MultiValueMap)headers), String.class, new Object[0]);
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u6839\u636e\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606fend\uff1a{}", forEntity.getBody());
        JSONObject resultJson = JSONObject.parseObject((String)((String)forEntity.getBody()));
        if (resultJson.getBoolean("success").booleanValue()) {
            return (ZlbUserInfo)JSONObject.parseObject((String)resultJson.getString("data"), ZlbUserInfo.class);
        }
        return null;
    }

    public ZlbUserInfo getZlbUserInfo(String ticket, String appId) {
        long start = System.currentTimeMillis();
        String token = this.getClientTicketCode(ticket, this.sysProperties.getZlb().getAppKey(), this.sysProperties.getZlb().getAppSecret(), appId);
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u7968\u636e\u8ba4\u8bc1\u8bf7\u6c42\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
        if (token == null) {
            return null;
        }
        start = System.currentTimeMillis();
        ZlbUserInfo clientInfoByToken = this.getClientInfoByToken(token, this.sysProperties.getZlb().getAppKey(), this.sysProperties.getZlb().getAppSecret());
        log.debug("\u6d59\u91cc\u529e\u767b\u5f55: \u6839\u636e\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
        return clientInfoByToken;
    }

    public ZlbClientServiceService(RestTemplate restTemplate, SysProperties sysProperties) {
        this.restTemplate = restTemplate;
        this.sysProperties = sysProperties;
    }
}

