/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.provider.sys;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.model.IdParam;
import cn.smarthse.core.framework.model.IdsParam;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.modules.sys.converter.sys.SysUserConverter;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.enums.sys.RhoUserRolesEnum;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyPushParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserAddForComParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserCreateEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserEditForComParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserEditForSupParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditByCidListForSupParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditForComParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditForSupParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysRoleDto;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyListForComVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyListForSupVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyOneForComVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyOneForSupVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyPushService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserRoleService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class SysUserServiceProviderImpl
implements ISysUserServiceProvider {
    private final IBCompanyService companyService;
    private final ISysUserService sysUserService;
    private final ISysUserRoleService sysUserRoleService;
    private final ISysAreaService sysAreaService;
    private final IBCompanyPushService companyPushService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    private final SysUserConverter converter;

    public LayuiGridData<SysUserCompanyListForSupVo> getSysCompanyUserListForSup(SysCompanyUserListParam param) {
        return new LayuiGridData(this.sysUserService.getSysCompanyUserListForSup(param), (LayuiGridParam)param);
    }

    public LayuiGridData<SysUserCompanyListForComVo> getSysCompanyUserListForCom(SysCompanyUserListParam param) {
        return new LayuiGridData(this.sysUserService.getSysCompanyUserListForCom(param), (LayuiGridParam)param);
    }

    public SysUserCompanyOneForSupVo getSysUserCompanyByUserIdForSup(Long userId) {
        SysUser sysUser = this.sysUserService.getUserById(userId);
        if (sysUser == null) {
            throw new ServiceException("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        SysUserCompanyOneForSupVo rst = this.converter.entity2SysUserCompanyOneForSupVo(sysUser);
        BCompany company = (BCompany)this.companyService.getById(sysUser.getCid());
        if (company != null) {
            rst.setHospitalName(company.getHospitalName());
            rst.setBranchName(company.getName());
            rst.setCreditCode(company.getCreditCode());
            rst.setMedicalNucode(company.getMedicalNucode());
            rst.setAreaId(company.getAreaId());
            SysAreaVo sysArea = this.sysAreaService.getAreaById(company.getAreaId());
            rst.setAreaName(sysArea.getName());
            rst.setSysArea(sysArea);
            rst.setBelongType(company.getBelongType());
            rst.setSupervisionUnit(company.getSupervisionUnit());
            rst.setSupervisionUnitStr(Optional.ofNullable(rst.getSupervisionUnit()).map(i -> this.organizationService.getOrgById(i).getName()).orElse("\u672a\u77e5"));
            rst.setIsTest(company.getIsTest());
        }
        return rst;
    }

    public SysUserCompanyOneForSupVo getSysUserCompanyByCidForSup(Long cid) {
        SysUserCompanyOneForSupVo rst;
        SysUser sysUser = this.sysUserService.getManagerUserByCid(cid);
        if (sysUser == null) {
            rst = new SysUserCompanyOneForSupVo();
            rst.setCid(cid);
        } else {
            rst = this.converter.entity2SysUserCompanyOneForSupVo(sysUser);
        }
        BCompany company = (BCompany)this.companyService.getById(cid);
        if (company != null) {
            rst.setHospitalName(company.getHospitalName());
            rst.setBranchName(company.getName());
            rst.setCreditCode(company.getCreditCode());
            rst.setMedicalNucode(company.getMedicalNucode());
            rst.setAreaId(company.getAreaId());
            SysAreaVo sysArea = this.sysAreaService.getAreaById(company.getAreaId());
            rst.setAreaName(sysArea.getName());
            rst.setSysArea(sysArea);
            rst.setBelongType(company.getBelongType());
            rst.setSupervisionUnit(company.getSupervisionUnit());
            rst.setSupervisionUnitStr(Optional.ofNullable(rst.getSupervisionUnit()).map(i -> this.organizationService.getOrgById(i).getName()).orElse("\u672a\u77e5"));
            rst.setIsTest(company.getIsTest());
            rst.setBusinessStatus(company.getBusinessStatus());
        }
        return rst;
    }

    public SysUserCompanyOneForComVo getSysUserCompanyByUserIdForCom(Long userId) {
        SysUser sysUser = this.sysUserService.getUserById(userId);
        if (sysUser == null) {
            throw new ServiceException("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        return this.converter.entity2SysUserCompanyOneForComVo(sysUser).setRoleList(this.converter.sysRoleVoList2SysRoleDtoList(this.sysUserRoleService.getRoleListByUserId(userId)));
    }

    public Boolean updateSysCompanyUserEditForSup(SysCompanyUserEditForSupParam param) {
        BCompany bCompany;
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(param.getAreaId());
        if (Objects.isNull(area)) {
            throw new ServiceException("\u8be5\u533a\u57df\u4e0d\u5b58\u5728");
        }
        if (area.getLevel() < 4) {
            throw new ServiceException("\u6240\u5728\u5730\u533a\u9700\u7cbe\u786e\u5230\u4e61\u9547\u8857\u9053");
        }
        if (this.companyService.isHaveThisBranchName(param.getBranchName(), param.getCid()).booleanValue()) {
            throw new ServiceException("\u8be5\u9662\u533a\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        Long areaId = Objects.equals(param.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : (Objects.equals(param.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : area.getAreaId());
        Organization org = this.organizationService.getOrganizationByAreaId(areaId);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper(BCompany.class);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(BCompany::getAreaId, (Object)param.getAreaId())).set(Objects.nonNull(param.getIsTest()), BCompany::getIsTest, (Object)param.getIsTest())).set(BCompany::getBelongType, (Object)param.getBelongType())).set(Objects.nonNull(org), BCompany::getSupervisionUnit, (Object)org.getId())).set(Objects.nonNull(org), BCompany::getSupervisionAreaId, (Object)org.getAreaId())).set(StrUtil.isNotBlank((CharSequence)param.getBranchName()), BCompany::getName, (Object)param.getBranchName())).set(StrUtil.isNotBlank((CharSequence)param.getCreditCode()), BCompany::getCreditCode, (Object)param.getCreditCode())).eq(BCompany::getId, (Object)param.getCid());
        boolean b = this.companyService.update((Wrapper)wrapper);
        if (!(!b || !Objects.nonNull(bCompany = (BCompany)this.companyService.getById(param.getCid())) || param.getBranchName().equals(bCompany.getName()) && param.getCreditCode().equals(bCompany.getCreditCode()) && param.getAreaId().equals(bCompany.getAreaId()))) {
            BCompanyPushParam pushParam = new BCompanyPushParam();
            pushParam.setCompany(bCompany);
            pushParam.setOptType(String.valueOf(2));
            pushParam.setOptReason("\u5b57\u6bb5\u53d8\u66f4");
            this.companyPushService.addPushData(pushParam);
        }
        if (StrUtil.isNotBlank((CharSequence)param.getUsername()) || Objects.nonNull(param.getId())) {
            if (!this.sysUserService.checkUsername(param.getUsername(), param.getId())) {
                throw new ServiceException("\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01");
            }
            SysUser user = new SysUser();
            user.setId(param.getId());
            user.setUsername(param.getUsername());
            user.setUpdateBy(param.getLoginUserId());
            user.setUpdateDate(LocalDateTime.now());
            this.sysUserService.updateById(user);
        }
        return b;
    }

    public Boolean updateSysCompanyUserEditForCom(SysCompanyUserEditForComParam param) {
        SysUser user = this.sysUserService.getUserById(param.getId());
        if (user == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        long[] list = StrUtil.splitToLong((CharSequence)user.getRoleIds(), (CharSequence)",");
        if (Arrays.stream(list).anyMatch(id -> id == RhoUserRolesEnum.RHO_COMPANY_SUPER_ADMIN.getRoleId()) && !Arrays.equals(list, param.getRoleList().stream().mapToLong(SysRoleDto::getRoleId).toArray())) {
            throw new ServiceException("\u62e5\u6709\u7ba1\u7406\u5458\u89d2\u8272\u7528\u6237\u4e0d\u53ef\u4fee\u6539\u89d2\u8272");
        }
        return this.sysUserService.updateSysCompanyUserEditForCom(param);
    }

    public Boolean updateSysCompanyUserStatueForSup(SysCompanyUserStatueEditForSupParam param) {
        return this.sysUserService.updateSysCompanyUserStatueForSup(param);
    }

    public Boolean updateSysCompanyUserExcludeSingleUserStatueByCidListForSup(SysCompanyUserStatueEditByCidListForSupParam param) {
        for (Long id : param.getIdList()) {
            SysCompanyUserStatueEditForSupParam dto = new SysCompanyUserStatueEditForSupParam();
            dto.setId(id);
            dto.setIsForbidden(param.getIsForbidden());
            dto.setLoginUserId(param.getLoginUserId());
            dto.setLoginUsername(param.getLoginUsername());
            this.sysUserService.updateSysCompanyUserStatueForSup(dto);
        }
        return true;
    }

    public Boolean updateSysCompanyUserStatueForCom(SysCompanyUserStatueEditForComParam param) {
        SysUser user = this.sysUserService.getUserById(param.getUserId());
        if (user == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        long[] list = StrUtil.splitToLong((CharSequence)user.getRoleIds(), (CharSequence)",");
        if (Arrays.stream(list).anyMatch(id -> id == RhoUserRolesEnum.RHO_COMPANY_SUPER_ADMIN.getRoleId())) {
            throw new ServiceException("\u62e5\u6709\u7ba1\u7406\u5458\u89d2\u8272\u7528\u6237\u4e0d\u53ef\u7981\u7528\u6216\u542f\u7528");
        }
        return this.sysUserService.updateSysCompanyUserStatueForCom(param);
    }

    public Boolean resetPasswordForSup(IdParam param) {
        return this.sysUserService.resetPassword(param);
    }

    public Boolean resetPasswordForCom(IdParam param) {
        SysUser user = this.sysUserService.getUserById(param.getId());
        if (user == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        long[] list = StrUtil.splitToLong((CharSequence)user.getRoleIds(), (CharSequence)",");
        if (Arrays.stream(list).anyMatch(id -> id == RhoUserRolesEnum.RHO_COMPANY_SUPER_ADMIN.getRoleId())) {
            throw new ServiceException("\u62e5\u6709\u7ba1\u7406\u5458\u89d2\u8272\u7528\u6237\u4e0d\u53ef\u91cd\u7f6e\u5bc6\u7801");
        }
        return this.sysUserService.resetPassword(param);
    }

    public SysUser getUserById(Long userId) {
        return this.sysUserService.getUserById(userId);
    }

    public List<SysUser> getUserListByCid(Long cid) {
        return this.sysUserService.getUserListByCid(cid);
    }

    public SysUser getManagerUserByCid(Long cid) {
        return this.sysUserService.getManagerUserByCid(cid);
    }

    public SysUser getUserByUsername(String username) {
        return this.sysUserService.getUserByUsername(username);
    }

    public void changePassword(Long userId, String oldPassword, String newPassword) {
        this.sysUserService.changePassword(userId, oldPassword, newPassword);
    }

    public SysUser addUserForCas(Long cid, String username, Integer userResource) {
        return this.sysUserService.addUserForCas(cid, username, userResource);
    }

    public Boolean addUserForSup(SysCompanyUserCreateEditParam param) {
        return this.sysUserService.addUserForSup(param);
    }

    public Boolean addUserByCidListForSup(IdsParam param) {
        return this.sysUserService.addUserByCidListForSup(param);
    }

    public Boolean addUserForCom(SysCompanyUserAddForComParam param) {
        return this.sysUserService.addUserForCom(param);
    }

    public Boolean deleteSysCompanyUserByCidListForSup(IdsParam param) {
        return this.sysUserService.delUserExcludeSingleUserByCidList(param);
    }

    public Boolean deleteSysCompanyUserByUserIdForCom(IdParam param) {
        return this.sysUserService.delUserByUserId(param.getId(), param.getLoginUserId());
    }

    public void updatePassStateThreeMonth() {
        this.sysUserService.updatePassStateThreeMonth();
    }

    public SysUserServiceProviderImpl(IBCompanyService companyService, ISysUserService sysUserService, ISysUserRoleService sysUserRoleService, ISysAreaService sysAreaService, IBCompanyPushService companyPushService, SysUserConverter converter) {
        this.companyService = companyService;
        this.sysUserService = sysUserService;
        this.sysUserRoleService = sysUserRoleService;
        this.sysAreaService = sysAreaService;
        this.companyPushService = companyPushService;
        this.converter = converter;
    }
}

