/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.provider.sms;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.map.MapUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.http.HttpUtil;
import cn.smarthse.core.framework.bootstrap.properties.MasSmsProperties;
import cn.smarthse.rho.modules.sys.provider.sms.ISMSProvideMasService;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class SmsProvideMasServiceImpl
implements ISMSProvideMasService {
    private static final Logger log = LoggerFactory.getLogger(SmsProvideMasServiceImpl.class);
    private final MasSmsProperties masSmsProperties;

    public void sendSms(String mobiles, String content) {
        if (StringUtils.isBlank((CharSequence)mobiles) || StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        String netAddr = this.masSmsProperties.getNetAddr();
        String[] mobileArr = StringUtils.splitByWholeSeparator((String)mobiles, (String)",");
        if (mobileArr.length >= 5000) {
            throw new ServiceException("\u4e00\u6b21\u6027\u4e0d\u80fd\u8d85\u8fc75000\u4e2a");
        }
        String addSerial = "";
        String ecName = this.masSmsProperties.getEcName();
        String apId = this.masSmsProperties.getAppId();
        String appSecret = this.masSmsProperties.getAppSecret();
        String sign = this.masSmsProperties.getSign();
        StringBuilder sb = new StringBuilder("");
        sb.append(ecName);
        sb.append(apId);
        sb.append(appSecret);
        sb.append(mobiles);
        sb.append(content);
        sb.append(sign);
        sb.append(addSerial);
        String mac = MD5.create().digestHex(sb.toString(), "UTF-8");
        JSONObject params = new JSONObject();
        params.put("ecName", (Object)ecName);
        params.put("apId", (Object)apId);
        params.put("mobiles", (Object)mobiles);
        params.put("content", (Object)content);
        params.put("sign", (Object)sign);
        params.put("addSerial", (Object)addSerial);
        params.put("mac", (Object)mac);
        String jsonString = JSON.toJSONString((Object)params);
        String encode = Base64.encode((CharSequence)jsonString);
        String response = HttpUtil.post((String)(netAddr + "/norsubmit"), (String)encode);
        log.debug("\u77ed\u4fe1\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)response);
    }

    public void sendMoreSms(Map<String, String> contentMap) {
        if (MapUtil.isEmpty(contentMap)) {
            return;
        }
        if (contentMap.size() >= 1000) {
            throw new ServiceException("\u4e00\u6b21\u6027\u4e0d\u80fd\u8d85\u8fc71000\u4e2a");
        }
        String mobiles = StringUtils.join((Iterable)contentMap.keySet().stream().collect(Collectors.toList()), (String)",");
        String content = JSON.toJSONString(contentMap);
        String netAddr = this.masSmsProperties.getNetAddr();
        String addSerial = "";
        String ecName = this.masSmsProperties.getEcName();
        String apId = this.masSmsProperties.getAppId();
        String appSecret = this.masSmsProperties.getAppSecret();
        String sign = this.masSmsProperties.getSign();
        StringBuilder sb = new StringBuilder("");
        sb.append(ecName);
        sb.append(apId);
        sb.append(appSecret);
        sb.append(mobiles);
        sb.append(content);
        sb.append(sign);
        sb.append(addSerial);
        String mac = MD5.create().digestHex(sb.toString(), "UTF-8");
        JSONObject params = new JSONObject();
        params.put("ecName", (Object)ecName);
        params.put("apId", (Object)apId);
        params.put("mobiles", (Object)mobiles);
        params.put("content", (Object)content);
        params.put("sign", (Object)sign);
        params.put("addSerial", (Object)addSerial);
        params.put("mac", (Object)mac);
        String jsonString = JSON.toJSONString((Object)params);
        String encode = Base64.encode((CharSequence)jsonString);
        String response = HttpUtil.post((String)(netAddr + "/norsubmit"), (String)encode);
        log.debug("\u591a\u5bf9\u591a\u77ed\u4fe1\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)response);
    }

    public SmsProvideMasServiceImpl(MasSmsProperties masSmsProperties) {
        this.masSmsProperties = masSmsProperties;
    }
}

