/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.provider.risk;

import cn.smarthse.rho.modules.sys.converter.RRiskBasicConverter;
import cn.smarthse.rho.modules.sys.dao.risk.RiskBasicCommonMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.r.RRiskAcceptanceRecord;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasic;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.BasicRiskStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskUnresolvedTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.SourceRiskStatusEnum;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskAcceptanceRecordCommonService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicCommonService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceHistoryCommonService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
@Transactional(readOnly=true)
public class RiskProviderImpl
implements IRiskProvider {
    @Autowired
    private RRiskBasicConverter rRiskBasicConverter;
    private final IRiskBasicCommonService riskBasicService;
    private final IRiskBasicSourceCommonService riskSourceService;
    private final IRiskAcceptanceRecordCommonService acceptanceRecordCommonService;
    private final RiskBasicCommonMapper riskBasicCommonMapper;
    private final IRiskBasicSourceHistoryCommonService sourceHistoryCommonService;
    private final IBCompanyService companyService;

    @Transactional
    public void genRiskOfCommon(List<AddRiskForCommonParam> paramList) {
        if (!CollectionUtils.isEmpty(paramList)) {
            Date date = new Date();
            List paramRiskList = this.rRiskBasicConverter.commonAddParamList2EntityList(paramList);
            ArrayList<Long> paramCidList = new ArrayList<Long>(paramRiskList.stream().map(RRiskBasic::getCid).collect(Collectors.toSet()));
            List<RRiskBasic> companyRiskBasicList = this.riskBasicCommonMapper.listRiskBasicByCid(paramCidList, LocalDate.now().getYear());
            ArrayList<RRiskBasic> addBasicList = new ArrayList<RRiskBasic>();
            ArrayList<RRiskBasicSource> addSourceList = new ArrayList<RRiskBasicSource>();
            ArrayList addAcceptanceRecordList = new ArrayList();
            this.determineBasicRisk(paramList, companyRiskBasicList, addBasicList);
            this.determineSourceRisk(paramList, addSourceList);
        }
    }

    @Transactional
    public void determineBasicRisk(List<AddRiskForCommonParam> paramRiskBasicList, List<RRiskBasic> dbRiskList, List<RRiskBasic> addBasicList) {
        RRiskBasic riskBasic = new RRiskBasic();
        List<Long> paramCidList = paramRiskBasicList.stream().map(AddRiskForCommonParam::getCid).distinct().collect(Collectors.toList());
        List<RRiskBasic> dbBasicList = this.riskBasicCommonMapper.listRiskBasicByCid(paramCidList, LocalDate.now().getYear());
        if (CollectionUtils.isEmpty(dbBasicList)) {
            for (AddRiskForCommonParam riskParam : paramRiskBasicList) {
                boolean anyMatch = addBasicList.stream().anyMatch(addBasic -> riskParam.getCid().equals(addBasic.getCid()) && riskParam.getType().equals(addBasic.getType()));
                if (anyMatch) continue;
                riskBasic = new RRiskBasic();
                riskBasic.setId(Long.valueOf(IdWorker.getId()));
                riskBasic.setCid(riskParam.getCid());
                riskBasic.setYear(Integer.valueOf(LocalDate.now().getYear()));
                riskBasic.setName(this.handleBasicRiskName(riskParam));
                riskBasic.setType(riskParam.getType());
                riskBasic.setStatus(BasicRiskStatusEnum.UNRESOLVED.getValue());
                riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
                riskBasic.setWarningStatus(RiskWarningStatusEnum.NONE.getValue());
                addBasicList.add(riskBasic);
            }
            this.riskBasicService.saveBatch(addBasicList);
            return;
        }
        for (AddRiskForCommonParam riskBasicParam : paramRiskBasicList) {
            boolean isExistInDb = dbBasicList.stream().anyMatch(dbRisk -> riskBasicParam.getCid().equals(dbRisk.getCid()) && riskBasicParam.getType().equals(dbRisk.getType()));
            boolean isExistInAddList = addBasicList.stream().anyMatch(dbRisk -> riskBasicParam.getCid().equals(dbRisk.getCid()) && riskBasicParam.getType().equals(dbRisk.getType()));
            if (isExistInDb || isExistInAddList) continue;
            riskBasic = new RRiskBasic();
            riskBasic.setId(Long.valueOf(IdWorker.getId()));
            riskBasic.setCid(riskBasicParam.getCid());
            riskBasic.setYear(Integer.valueOf(LocalDate.now().getYear()));
            riskBasic.setName(this.handleBasicRiskName(riskBasicParam));
            riskBasic.setType(riskBasicParam.getType());
            riskBasic.setStatus(BasicRiskStatusEnum.UNRESOLVED.getValue());
            riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
            riskBasic.setWarningStatus(RiskWarningStatusEnum.NONE.getValue());
            addBasicList.add(riskBasic);
        }
        this.riskBasicService.saveBatch(addBasicList);
    }

    @Transactional
    public void determineSourceRisk(List<AddRiskForCommonParam> paramRiskBasicList, List<RRiskBasicSource> addSourceList) {
        RRiskBasicSource addSource = new RRiskBasicSource();
        ArrayList<RRiskAcceptanceRecord> addAcceptanceRecordList = new ArrayList<RRiskAcceptanceRecord>();
        ArrayList<RRiskBasicSource> updateSourceList = new ArrayList<RRiskBasicSource>();
        ArrayList<RRiskBasicSource> sourceHistoryList = new ArrayList<RRiskBasicSource>();
        for (AddRiskForCommonParam riskBasicParam : paramRiskBasicList) {
            RRiskBasicSource dbSource = this.riskBasicCommonMapper.searchSourceByBusinessId(riskBasicParam.getType(), riskBasicParam.getCid(), riskBasicParam.getSubBusinessId(), LocalDate.now().getYear());
            if (dbSource == null) {
                RRiskBasic basic = this.riskBasicCommonMapper.searchBasicForSource(riskBasicParam.getCid(), riskBasicParam.getType(), LocalDate.now().getYear());
                addSource = this.rRiskBasicConverter.commonAddParam2SourceEntity(riskBasicParam);
                addSource.setId(Long.valueOf(IdWorker.getId()));
                addSource.setRiskId(basic.getId());
                addSource.setYear(Integer.valueOf(LocalDate.now().getYear()));
                addSource.setFindTime(LocalDate.now());
                addSource.setName(this.handleSourceRiskName(riskBasicParam));
                addSource.setRequireFinishTime(riskBasicParam.getRequireFinishTime());
                addSource.setStatus(SourceRiskStatusEnum.UN_RESOLVED.getValue());
                addSource.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
                addSource.setBusinessStartDate(riskBasicParam.getStartTime());
                if (riskBasicParam.getIsGenerateByData() == 1) {
                    addSource.setWarningStatus(RiskWarningStatusEnum.NONE.getValue());
                } else {
                    addSource.setWarningStatus(RiskWarningStatusEnum.RED.getValue());
                }
                if (riskBasicParam.getType() == RiskTypeEnum.LICENSE_MANAGEMENT.getValue()) {
                    addSource.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
                }
                addSourceList.add(addSource);
                continue;
            }
            if (dbSource.getStatus() == SourceRiskStatusEnum.RESOLVED.getValue()) {
                sourceHistoryList.add(dbSource);
                dbSource.setName(this.handleSourceRiskName(riskBasicParam));
                dbSource.setYear(Integer.valueOf(LocalDate.now().getYear()));
                dbSource.setFindTime(LocalDate.now());
                dbSource.setRequireFinishTime(riskBasicParam.getRequireFinishTime());
                dbSource.setStatus(SourceRiskStatusEnum.UN_RESOLVED.getValue());
                dbSource.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
                dbSource.setWarningStatus(RiskWarningStatusEnum.NONE.getValue());
                dbSource.setBusinessStartDate(riskBasicParam.getStartTime());
                dbSource.setIsGenerateByData(riskBasicParam.getIsGenerateByData());
                updateSourceList.add(dbSource);
                continue;
            }
            if (dbSource.getStatus() != SourceRiskStatusEnum.UN_RESOLVED.getValue() || dbSource.getIsGenerateByData() != 0 || riskBasicParam.getIsGenerateByData() != 1) continue;
            sourceHistoryList.add(dbSource);
            dbSource.setName(this.handleSourceRiskName(riskBasicParam));
            dbSource.setYear(Integer.valueOf(LocalDate.now().getYear()));
            dbSource.setFindTime(LocalDate.now());
            dbSource.setRequireFinishTime(riskBasicParam.getRequireFinishTime());
            dbSource.setStatus(SourceRiskStatusEnum.UN_RESOLVED.getValue());
            dbSource.setUnresolvedType(RiskUnresolvedTypeEnum.UN_RECTIFY.getValue());
            dbSource.setWarningStatus(RiskWarningStatusEnum.NONE.getValue());
            dbSource.setBusinessStartDate(riskBasicParam.getStartTime());
            dbSource.setIsGenerateByData(riskBasicParam.getIsGenerateByData());
            updateSourceList.add(dbSource);
        }
        if (!CollectionUtils.isEmpty(addSourceList)) {
            this.riskSourceService.saveBatch(addSourceList);
            for (RRiskBasicSource source : addSourceList) {
                if (source.getType() != RiskTypeEnum.LICENSE_MANAGEMENT.getValue()) continue;
                RRiskAcceptanceRecord acceptanceRecord = new RRiskAcceptanceRecord();
                acceptanceRecord.setId(Long.valueOf(IdWorker.getId()));
                acceptanceRecord.setRiskId(source.getRiskId());
                acceptanceRecord.setSourceId(source.getId());
                acceptanceRecord.setCid(source.getCid());
                acceptanceRecord.setRequireFinishTime(source.getRequireFinishTime());
                acceptanceRecord.setStatus(Integer.valueOf(0));
                acceptanceRecord.setAcceptanceResult(null);
                addAcceptanceRecordList.add(acceptanceRecord);
            }
            this.acceptanceRecordCommonService.saveBatch(addAcceptanceRecordList);
        }
        if (!CollectionUtils.isEmpty(updateSourceList)) {
            this.sourceHistoryCommonService.saveSourceAsHistory(sourceHistoryList, "\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\u98ce\u9669");
            this.riskSourceService.updateBatchById(updateSourceList);
        }
    }

    @Transactional
    public void resolveRiskOfCommon(List<Long> sourceIdList) {
        if (CollectionUtils.isEmpty(sourceIdList)) {
            return;
        }
        List sourceList = this.riskSourceService.listByIds(sourceIdList);
        this.sourceHistoryCommonService.saveSourceAsHistory(sourceList, "\u7cfb\u7edf\u81ea\u52a8\u5316\u89e3\u98ce\u9669");
        for (RRiskBasicSource source : sourceList) {
            source.setStatus(BasicRiskStatusEnum.RESOLVED.getValue());
            source.setUnresolvedType(RiskUnresolvedTypeEnum.NONE.getValue());
            source.setActualFinishTime(LocalDate.now());
            source.setReformDirectorName("\u7cfb\u7edf\u81ea\u52a8\u6574\u6539\u9a8c\u6536");
            source.setAcceptanceDirectorName("\u7cfb\u7edf\u81ea\u52a8\u6574\u6539\u9a8c\u6536");
            source.setAcceptanceDate(LocalDate.now());
        }
        this.riskSourceService.updateBatchById(sourceList);
        ArrayList<RRiskBasic> basicList = new ArrayList<RRiskBasic>();
        List basicIdList = sourceList.stream().map(RRiskBasicSource::getRiskId).distinct().collect(Collectors.toList());
        for (Long basicId : basicIdList) {
            List<RRiskBasicSource> curSourceRelatedData = this.riskSourceService.listSourceByBasicId(basicId);
            if (!curSourceRelatedData.stream().allMatch(curSource -> curSource.getStatus().equals(BasicRiskStatusEnum.RESOLVED.getValue()))) continue;
            RRiskBasic basic = (RRiskBasic)this.riskBasicService.getById(basicId);
            basic.setStatus(BasicRiskStatusEnum.RESOLVED.getValue());
            basic.setUnresolvedType(RiskUnresolvedTypeEnum.NONE.getValue());
            basicList.add(basic);
        }
        this.riskBasicService.updateBatchById(basicList);
    }

    @Transactional
    public void searchAndChangeSourceRiskWarningStatus(RiskMangerGenParam param) {
        ArrayList<RRiskBasicSource> firstWarningList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceFirstWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> placeFirstWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> phyExamWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> trainWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        firstWarningList.addAll(performanceFirstWarningList);
        firstWarningList.addAll(placeFirstWarningList);
        firstWarningList.addAll(phyExamWarningList);
        firstWarningList.addAll(trainWarningList);
        if (!CollectionUtils.isEmpty(firstWarningList)) {
            this.sourceHistoryCommonService.saveSourceAsHistory(firstWarningList, "\u9996\u6b21\u9884\u8b66\u53d8\u66f4\u4e3a\u9ec4\u8272\u9884\u8b66\u3002");
            firstWarningList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.YELLOW.getValue()));
            this.riskSourceService.updateBatchById(firstWarningList);
            firstWarningList = null;
        }
        ArrayList<RRiskBasicSource> yellowWarningList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceYellowWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> placeYellowWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> phyExamYellowWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> trainYellowWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        yellowWarningList.addAll(performanceYellowWarningList);
        yellowWarningList.addAll(placeYellowWarningList);
        yellowWarningList.addAll(phyExamYellowWarningList);
        yellowWarningList.addAll(trainYellowWarningList);
        if (!CollectionUtils.isEmpty(yellowWarningList)) {
            this.sourceHistoryCommonService.saveSourceAsHistory(yellowWarningList, "\u9ec4\u6b21\u9884\u8b66\u53d8\u66f4\u4e3a\u7ea2\u8272\u9884\u8b66\u3002");
            yellowWarningList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.RED.getValue()));
            this.riskSourceService.updateBatchById(yellowWarningList);
            yellowWarningList = null;
        }
        ArrayList<RRiskBasicSource> redWarningList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceRedWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> placeRedWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> phyExamRedWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> trainRedWarningList = this.riskSourceService.listWarningSource(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.RED.getValue());
        redWarningList.addAll(performanceRedWarningList);
        redWarningList.addAll(placeRedWarningList);
        redWarningList.addAll(phyExamRedWarningList);
        redWarningList.addAll(trainRedWarningList);
        if (!CollectionUtils.isEmpty(redWarningList)) {
            this.sourceHistoryCommonService.saveSourceAsHistory(redWarningList, "\u7ea2\u6b21\u9884\u8b66\u53d8\u66f4\u4e3a\u542f\u52a8\u6267\u6cd5\u3002");
            redWarningList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.ACTIVATE_LAW.getValue()));
            this.riskSourceService.updateBatchById(redWarningList);
            redWarningList = null;
        }
        ArrayList<RRiskBasicSource> changeToFirstWarningList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceFirstWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> placeFirstWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> phyExamWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> trainWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        changeToFirstWarningList.addAll(performanceFirstWarningListForNone);
        changeToFirstWarningList.addAll(placeFirstWarningListForNone);
        changeToFirstWarningList.addAll(phyExamWarningListForNone);
        changeToFirstWarningList.addAll(trainWarningListForNone);
        if (!CollectionUtils.isEmpty(changeToFirstWarningList)) {
            changeToFirstWarningList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.FIRST.getValue()));
            this.riskSourceService.updateBatchById(changeToFirstWarningList);
            changeToFirstWarningList = null;
        }
        ArrayList<RRiskBasicSource> changeToYellowWarningList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceYellowWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> placeYellowWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> phyExamYellowWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> trainYellowWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        changeToYellowWarningList.addAll(performanceYellowWarningListForNone);
        changeToYellowWarningList.addAll(placeYellowWarningListForNone);
        changeToYellowWarningList.addAll(phyExamYellowWarningListForNone);
        changeToYellowWarningList.addAll(trainYellowWarningListForNone);
        if (!CollectionUtils.isEmpty(changeToYellowWarningList)) {
            changeToYellowWarningList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.YELLOW.getValue()));
            this.riskSourceService.updateBatchById(changeToYellowWarningList);
            changeToYellowWarningList = null;
        }
        ArrayList<RRiskBasicSource> changeToRedWarningList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceRedWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> placeRedWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> phyExamRedWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> trainRedWarningListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.RED.getValue());
        changeToRedWarningList.addAll(performanceRedWarningListForNone);
        changeToRedWarningList.addAll(placeRedWarningListForNone);
        changeToRedWarningList.addAll(phyExamRedWarningListForNone);
        changeToRedWarningList.addAll(trainRedWarningListForNone);
        if (!CollectionUtils.isEmpty(changeToRedWarningList)) {
            changeToRedWarningList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.RED.getValue()));
            this.riskSourceService.updateBatchById(changeToRedWarningList);
            changeToRedWarningList = null;
        }
        ArrayList<RRiskBasicSource> changeToActivateLawList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceActivateLawListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> placeActivateLawListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> phyExamActivateLawListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> trainActivateLawListForNone = this.riskSourceService.listWarningSourceForNoneWarningStatus(RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        changeToActivateLawList.addAll(performanceActivateLawListForNone);
        changeToActivateLawList.addAll(placeActivateLawListForNone);
        changeToActivateLawList.addAll(phyExamActivateLawListForNone);
        changeToActivateLawList.addAll(trainActivateLawListForNone);
        if (!CollectionUtils.isEmpty(changeToActivateLawList)) {
            changeToActivateLawList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.ACTIVATE_LAW.getValue()));
            this.riskSourceService.updateBatchById(changeToActivateLawList);
            changeToActivateLawList = null;
        }
    }

    @Transactional
    public void searchAndChangeBasicRiskWarningStatus(RiskMangerGenParam param) {
        this.riskBasicService.changeBasicWarningStatus(param);
    }

    public String handleBasicRiskName(AddRiskForCommonParam riskParam) {
        if (riskParam.getCompanyName() == null) {
            BCompany company = (BCompany)this.companyService.getById(riskParam.getCid());
            riskParam.setCompanyName(company.getName());
        }
        if (riskParam.getType() == RiskTypeEnum.LICENSE_MANAGEMENT.getValue()) {
            String secName = riskParam.getIsGenerateByData() == 0 ? "\u672a\u53ca\u65f6\u5f00\u5c55\u8bb8\u53ef\u6821\u9a8c" : "\u8bb8\u53ef\u5373\u5c06\u5230\u671f";
            return String.format("%s\u5e74\u4efd-%s", LocalDate.now().getYear(), secName);
        }
        if (riskParam.getType() == RiskTypeEnum.THREE.getValue()) {
            return String.format("\u5efa\u8bbe\u9879\u76ee\u201c\u4e09\u540c\u65f6\u201d\u5b58\u5728\u98ce\u9669", LocalDate.now().getYear());
        }
        String riskTypeName = RiskTypeEnum.getName((Integer)riskParam.getType());
        return String.format("%s\u5e74\u4efd-%s\u5b58\u5728\u98ce\u9669", LocalDate.now().getYear(), riskTypeName);
    }

    public String handleSourceRiskName(AddRiskForCommonParam riskParam) {
        if (riskParam.getCompanyName() == null) {
            BCompany company = (BCompany)this.companyService.getById(riskParam.getCid());
            riskParam.setCompanyName(company.getName());
        }
        if (riskParam.getType() == RiskTypeEnum.LICENSE_MANAGEMENT.getValue()) {
            String secName = riskParam.getIsGenerateByData() == 0 ? "\u672a\u53ca\u65f6\u5f00\u5c55\u8bb8\u53ef\u6821\u9a8c" : "\u8bb8\u53ef\u5373\u5c06\u5230\u671f";
            return String.format("%s\u5e74\u4efd-%s", LocalDate.now().getYear(), secName);
        }
        if (riskParam.getType() == RiskTypeEnum.THREE.getValue()) {
            return String.format("%s\u8bbe\u5907-\u672a\u5f00\u5c55\u5efa\u8bbe\u9879\u76ee\u201c\u4e09\u540c\u65f6\u201d", LocalDate.now().getYear());
        }
        String riskTypeName = RiskTypeEnum.getName((Integer)riskParam.getType());
        String secName = riskParam.getIsGenerateByData() == 0 ? "\u672a\u53ca\u65f6\u5f00\u5c55" + riskTypeName : riskTypeName + "\u5373\u5c06\u5931\u6548";
        return String.format("%s-%s", riskParam.getSubBusinessName(), secName);
    }

    public RiskProviderImpl(IRiskBasicCommonService riskBasicService, IRiskBasicSourceCommonService riskSourceService, IRiskAcceptanceRecordCommonService acceptanceRecordCommonService, RiskBasicCommonMapper riskBasicCommonMapper, IRiskBasicSourceHistoryCommonService sourceHistoryCommonService, IBCompanyService companyService) {
        this.riskBasicService = riskBasicService;
        this.riskSourceService = riskSourceService;
        this.acceptanceRecordCommonService = acceptanceRecordCommonService;
        this.riskBasicCommonMapper = riskBasicCommonMapper;
        this.sourceHistoryCommonService = sourceHistoryCommonService;
        this.companyService = companyService;
    }
}

