/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.provider.b;

import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.modules.sys.converter.b.BcompanyConverter;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.enums.company.BusinessStatusEnum;
import cn.smarthse.rho.modules.sys.manger.company.CompanyEditManager;
import cn.smarthse.rho.modules.sys.manger.company.CompanyImportManager;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyAdminEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyPushParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.model.easyexcel.CompanyImportDto;
import cn.smarthse.rho.modules.sys.model.sys.param.BCompanyChooseListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyStatueEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserBusinessStatueEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditForSupParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.BCompanyChooseVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysCompanyListVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysCompanyOneVo;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyPushService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.rho.modules.sys.service.sys.ISysParamService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserService;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class CompanyProviderImpl
implements ICompanyProvider {
    private final BcompanyConverter converter;
    private final CompanyImportManager companyImportManager;
    private final CompanyEditManager companyEditManager;
    private final IBCompanyService companyService;
    private final ISysParamService sysParamService;
    private final ISysAreaService sysAreaService;
    private final ISysUserService sysUserService;
    private final IBCompanyPushService companyPushService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;

    public Boolean isHasBelongTypeComByAreaId(Long areaId) {
        return this.companyService.isHasBelongTypeComByAreaId(areaId);
    }

    public BCompanyVo getCompany(Long cid) {
        BCompany bCompany = (BCompany)this.companyService.getById(cid);
        if (bCompany == null) {
            return null;
        }
        BCompanyVo result = this.converter.BCompany2BCompanyVo(bCompany);
        result.setType(bCompany.getType());
        result.setTypeName(this.sysParamService.getName(result.getType()));
        result.setUnitLevelName(this.sysParamService.getName(result.getUnitLevel()));
        result.setBusinessTypeName(this.sysParamService.getName(result.getBusinessType()));
        result.setFullAddress(this.sysAreaService.getAreaAddress(bCompany.getAreaId(), "") + bCompany.getAddress());
        return result;
    }

    public PageInfo<BCompanyVo> getListForZLB(SysCompanyListParam param) {
        return this.companyService.getListForZLB(param);
    }

    public Map<String, Object> getSuperviseUnit(Long cid) {
        BCompany company = (BCompany)this.companyService.getById(cid);
        if (company == null || company.getAreaId() == null || company.getBelongType() == null) {
            return null;
        }
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(company.getAreaId());
        if (Objects.isNull(area)) {
            return null;
        }
        Integer belongType = company.getBelongType();
        Long areaId = Objects.equals(belongType, CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : (Objects.equals(belongType, CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : area.getAreaId());
        Organization org = this.organizationService.getOrganizationByAreaId(areaId);
        if (Objects.nonNull(org)) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("id", org.getId());
            result.put("name", org.getName());
            return result;
        }
        return null;
    }

    public LayuiGridData<BCompanyChooseVo> getChooseList(BCompanyChooseListParam param) {
        return new LayuiGridData(this.companyService.getChooseList(param));
    }

    public LayuiGridData<SysCompanyListVo> getSysCompanyListData(SysCompanyListParam param) {
        return new LayuiGridData(this.companyService.getSysCompanyListData(param));
    }

    public SysCompanyOneVo getSysCompany(Long cid) {
        return this.companyService.getSysCompany(cid);
    }

    public Boolean updateSysCompany(SysCompanyEditParam param) {
        BCompany bCompany;
        boolean b = this.companyService.updateSysCompany(param);
        if (b && Objects.nonNull(bCompany = (BCompany)this.companyService.getById(param.getBranchCid())) && !param.getBranchName().equals(bCompany.getName())) {
            BCompanyPushParam pushParam = new BCompanyPushParam();
            pushParam.setCompany(bCompany);
            pushParam.setOptType(String.valueOf(2));
            pushParam.setOptReason("\u533b\u9662\u540d\u79f0\u53d8\u66f4");
            this.companyPushService.addPushData(pushParam);
        }
        return b;
    }

    public Boolean updateSysCompanyStatue(SysCompanyStatueEditParam param) {
        boolean b = this.companyService.updateSysCompanyStatue(param);
        if (param.getState() == 0 && b) {
            SysCompanyUserStatueEditForSupParam dto = new SysCompanyUserStatueEditForSupParam();
            dto.setId(param.getBranchCid());
            dto.setIsForbidden(Integer.valueOf(1));
            this.sysUserService.updateSysCompanyUserStatueForSup(dto);
        }
        return b;
    }

    public Boolean updateSysCompanyIsMain(SysCompanyStatueEditParam param) {
        return this.companyService.updateSysCompanyIsMain(param);
    }

    public Boolean updateSysCompanyBusinessStatue(SysCompanyUserBusinessStatueEditParam param) {
        boolean b = this.companyService.updateSysCompanyBusinessStatue(param);
        if (b) {
            BCompany bCompany = (BCompany)this.companyService.getById(param.getCid());
            if (Objects.nonNull(bCompany) && !param.getBusinessStatus().equals(bCompany.getBusinessStatus())) {
                BCompanyPushParam pushParam = new BCompanyPushParam();
                pushParam.setCompany(bCompany);
                pushParam.setOptType(String.valueOf(2));
                pushParam.setOptReason("\u8425\u4e1a\u72b6\u6001\u53d8\u66f4");
                this.companyPushService.addPushData(pushParam);
            }
            if (Objects.equals(param.getBusinessStatus(), BusinessStatusEnum.CLOSE.getValue())) {
                SysCompanyUserStatueEditForSupParam dto = new SysCompanyUserStatueEditForSupParam();
                dto.setId(param.getCid());
                dto.setIsForbidden(Integer.valueOf(1));
                this.sysUserService.updateSysCompanyUserStatueForSup(dto);
            }
        }
        return b;
    }

    public void importCompany(List<CompanyImportDto> paramList) {
        this.companyImportManager.importCompany(paramList);
    }

    public void addInfo(BCompanyAdminEditParam param) {
        this.companyEditManager.addInfo(param);
    }

    public CompanyProviderImpl(BcompanyConverter converter, CompanyImportManager companyImportManager, CompanyEditManager companyEditManager, IBCompanyService companyService, ISysParamService sysParamService, ISysAreaService sysAreaService, ISysUserService sysUserService, IBCompanyPushService companyPushService) {
        this.converter = converter;
        this.companyImportManager = companyImportManager;
        this.companyEditManager = companyEditManager;
        this.companyService = companyService;
        this.sysParamService = sysParamService;
        this.sysAreaService = sysAreaService;
        this.sysUserService = sysUserService;
        this.companyPushService = companyPushService;
    }
}

