/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.staff.staffSync;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoSyncVo;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.utils.staff.StaffUniqueReferenceUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class WandaStaffCMInfoSyncHCManager {
    private static final Logger log = LoggerFactory.getLogger(WandaStaffCMInfoSyncHCManager.class);
    private final IBCompanyService companyService;
    private final ICHealthCheckDataService healthCheckDataService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final RedissonClient redissonClient;
    @Autowired
    private ApplicationContext applicationContext;
    private static final String LOCK_KEY = "WandaStaffCMInfoSyncManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void syncWandaStaffData(WandaSyncParam param) {
        log.debug("wanda\u4eba\u5458\u533b\u9662\u5173\u8054\u540c\u6b65\uff1a syncWandaStaffData() start");
        StringBuilder sb = new StringBuilder(LOCK_KEY);
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                WandaStaffCMInfoSyncHCManager self = (WandaStaffCMInfoSyncHCManager)this.applicationContext.getBean(WandaStaffCMInfoSyncHCManager.class);
                self.syncWandaStaffDataLock(param);
                log.debug("wanda\u4eba\u5458\u533b\u9662\u5173\u8054\u540c\u6b65\uff1a syncWandaStaffData() end");
            }
            catch (Exception e) {
                log.error("wanda\u4eba\u5458\u533b\u9662\u5173\u8054\u540c\u6b65\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:syncWandaStaffData()", (Object)LOCK_KEY);
        }
    }

    @Transactional
    public void syncWandaStaffDataLock(WandaSyncParam param) {
        List<CStaffInfoSyncVo> list = this.staffBaseInfoService.getWandaSyncStaffInfoFromCHData(param);
        List<CStaffInfoSyncVo> canSyncList = list.stream().filter(v -> this.canSync((CStaffInfoSyncVo)v)).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(canSyncList)) {
            this.saveStaffInfo(canSyncList);
        }
    }

    @Transactional
    public void saveStaffInfo(List<CStaffInfoSyncVo> canSyncList) {
        for (CStaffInfoSyncVo vo : canSyncList) {
            CStaffBaseInfo staffBaseInfo;
            if (StrUtil.isBlank((CharSequence)vo.getHealthCheckIdListStr())) continue;
            List healthCheckIdList = StrUtil.split((CharSequence)vo.getHealthCheckIdListStr(), (CharSequence)",");
            List healthCheckDataList = this.healthCheckDataService.listByIds(healthCheckIdList);
            vo.setHealthCheckList(healthCheckDataList);
            if (CollUtil.isEmpty((Collection)vo.getHealthCheckList()) || (staffBaseInfo = this.staffBaseInfoService.getOneByIdCard(vo.getIdcard())) == null) continue;
            List<Long> cidList = this.extractCid(vo, staffBaseInfo);
            this.saveStaffInfoList(cidList, staffBaseInfo, vo);
        }
    }

    @Transactional
    public void saveStaffInfoList(List<Long> cidList, CStaffBaseInfo staffBaseInfo, CStaffInfoSyncVo vo) {
        if (CollUtil.isEmpty(cidList)) {
            return;
        }
        Long staffBaseInfoId = staffBaseInfo.getId();
        for (Long cid : cidList) {
            CStaff staffEntity = this.staffService.getByBaseIdAndBranchCid(staffBaseInfoId, cid);
            if (staffEntity != null || (staffEntity = this.wandaSyncInfo2StaffInfoEntity(cid, staffBaseInfo, vo)) == null) continue;
            this.staffService.save(staffEntity);
        }
    }

    private List<Long> extractCid(CStaffInfoSyncVo vo, CStaffBaseInfo entity) {
        ArrayList healthCheckList = vo.getHealthCheckList();
        if (CollUtil.isEmpty((Collection)healthCheckList)) {
            return null;
        }
        if ((healthCheckList = CollUtil.distinct((Collection)healthCheckList, e -> e.getId(), (boolean)true)).size() == 1) {
            return Collections.singletonList(((CHealthCheckData)healthCheckList.get(0)).getCid());
        }
        Map<Long, List<CHealthCheckData>> healCheckListMap = healthCheckList.stream().filter(v -> v.getCid() != null).collect(Collectors.groupingBy(v -> v.getCid()));
        ArrayList tempList = new ArrayList();
        healCheckListMap.forEach((k, list) -> {
            if (CollUtil.isNotEmpty((Collection)list)) {
                List sortList = CollUtil.sort((List)list, (s1, s2) -> CompareUtil.compare((Comparable)s1.getCheckDate(), (Comparable)s2.getCheckDate(), (boolean)false));
                tempList.add(sortList.get(0));
            }
        });
        healthCheckList = tempList;
        if (CollUtil.isEmpty(healthCheckList)) {
            return null;
        }
        if (healthCheckList.size() == 1) {
            return Collections.singletonList(((CHealthCheckData)healthCheckList.get(0)).getCid());
        }
        Map<String, List<CHealthCheckData>> creditCodeHeckCheckListMap = healthCheckList.stream().filter(v -> StrUtil.isNotBlank((CharSequence)v.getCreditCode())).collect(Collectors.groupingBy(v -> v.getCreditCode()));
        ArrayList tempList2 = new ArrayList();
        creditCodeHeckCheckListMap.forEach((k, list) -> {
            if (CollUtil.isNotEmpty((Collection)list)) {
                List sortList = CollUtil.sort((List)list, (s1, s2) -> CompareUtil.compare((Comparable)s1.getCheckDate(), (Comparable)s2.getCheckDate(), (boolean)false));
                tempList2.add(sortList.get(0));
            }
        });
        healthCheckList = tempList2;
        if (CollUtil.isEmpty(healthCheckList)) {
            return null;
        }
        List<Long> result = healthCheckList.stream().map(v -> v.getCid()).collect(Collectors.toList());
        return result;
    }

    private CStaff wandaSyncInfo2StaffInfoEntity(Long cid, CStaffBaseInfo staffBaseInfo, CStaffInfoSyncVo vo) {
        BCompany company = (BCompany)this.companyService.getById(cid);
        if (company == null) {
            return null;
        }
        CStaff entity = new CStaff();
        entity.setBaseId(staffBaseInfo.getId());
        entity.setCid(cid);
        entity.setEditTime(LocalDateTime.now());
        entity.setSource(StaffSourceEnum.WAND_HC.getValue());
        entity.setUniqueReference(StaffUniqueReferenceUtil.genUniqueReference((String)company.getCreditCode(), (Long)staffBaseInfo.getId()));
        return entity;
    }

    private boolean canSync(CStaffInfoSyncVo vo) {
        boolean flag = true;
        if (vo.getPost() == null) {
            flag = false;
        }
        if (StrUtil.isBlank((CharSequence)vo.getHealthCheckIdListStr())) {
            flag = false;
        }
        return flag;
    }

    public WandaStaffCMInfoSyncHCManager(IBCompanyService companyService, ICHealthCheckDataService healthCheckDataService, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, RedissonClient redissonClient) {
        this.companyService = companyService;
        this.healthCheckDataService = healthCheckDataService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.redissonClient = redissonClient;
    }
}

