/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.staff.baseInfoSync;

import cn.smarthse.rho.modules.sys.manger.staff.baseInfoSync.WandaStaffBaseInfoSyncDoseManager;
import cn.smarthse.rho.modules.sys.manger.staff.baseInfoSync.WandaStaffBaseInfoSyncHCManager;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class WandaStaffBaseInfoSyncManager {
    private static final Logger log = LoggerFactory.getLogger(WandaStaffBaseInfoSyncManager.class);
    private final IBCompanyService companyService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final RedissonClient redissonClient;
    private final WandaStaffBaseInfoSyncHCManager syncHCManager;
    private final WandaStaffBaseInfoSyncDoseManager syncDoseManager;
    @Autowired
    private ApplicationContext applicationContext;
    public static final String LOCK_KEY = "WandaStaffBaseInfoSyncManager";

    @Transactional
    public void syncWandaStaffData(WandaSyncParam wandaSyncParam) {
        this.syncHCManager.syncWandaStaffData(wandaSyncParam);
        this.syncDoseManager.syncWandaStaffData(wandaSyncParam);
    }

    @Transactional
    public void syncWandaStaffDataBySql(WandaSyncParam wandaSyncParam) {
        this.staffBaseInfoService.insertStaffBaseInfoFromHC(wandaSyncParam);
        this.staffBaseInfoService.insertStaffBaseInfoFromDose(wandaSyncParam);
    }

    public WandaStaffBaseInfoSyncManager(IBCompanyService companyService, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, RedissonClient redissonClient, WandaStaffBaseInfoSyncHCManager syncHCManager, WandaStaffBaseInfoSyncDoseManager syncDoseManager) {
        this.companyService = companyService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.redissonClient = redissonClient;
        this.syncHCManager = syncHCManager;
        this.syncDoseManager = syncDoseManager;
    }
}

