/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.staff.baseInfoSync;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoSyncVo;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WandaStaffBaseInfoSyncDoseManager {
    private static final Logger log = LoggerFactory.getLogger(WandaStaffBaseInfoSyncDoseManager.class);
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final RedissonClient redissonClient;
    @Autowired
    private ApplicationContext applicationContext;
    private static final String LOCK_KEY = "WandaStaffBaseInfoSyncManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void syncWandaStaffData(WandaSyncParam param) {
        log.debug("wanda\u4eba\u5458\u540c\u6b65\uff1a syncWandaStaffData() start");
        StringBuilder sb = new StringBuilder(LOCK_KEY);
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.syncWandaStaffDataLock(param);
                log.debug("wanda\u4eba\u5458\u540c\u6b65\uff1a syncWandaStaffData() end");
            }
            catch (Exception e) {
                log.error("wanda\u4eba\u5458\u540c\u6b65\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:syncWandaStaffData()", (Object)LOCK_KEY);
        }
    }

    @Transactional
    public void syncWandaStaffDataLock(WandaSyncParam param) {
        List<CStaffInfoSyncVo> list = this.staffBaseInfoService.getWandaSyncInfoFromDoseData(param);
        List<CStaffInfoSyncVo> canSyncList = list.stream().filter(v -> this.canSync((CStaffInfoSyncVo)v)).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(canSyncList)) {
            try {
                this.saveStaffBaseInfo(canSyncList);
            }
            catch (Exception e) {
                log.error("wanda\u4eba\u5458\u540c\u6b65\u5931\u8d25\uff1a{}", (Throwable)e);
            }
        }
    }

    @Transactional
    public void saveStaffBaseInfo(List<CStaffInfoSyncVo> canSyncList) {
        ArrayList<CStaffBaseInfo> resultList = new ArrayList<CStaffBaseInfo>();
        for (CStaffInfoSyncVo vo : canSyncList) {
            CStaffBaseInfo entity = this.staffBaseInfoService.getOneByIdCard(vo.getIdcard());
            if (entity == null) {
                entity = this.wandaSyncInfo2BaseInfoEntity(vo);
                resultList.add(entity);
            }
            if (resultList.size() < 500) continue;
            this.staffBaseInfoService.saveBatch(resultList);
            resultList.clear();
        }
        if (CollUtil.isNotEmpty(resultList)) {
            this.staffBaseInfoService.saveBatch(resultList);
        }
    }

    private CStaffBaseInfo wandaSyncInfo2BaseInfoEntity(CStaffInfoSyncVo vo) {
        CStaffBaseInfo entity = new CStaffBaseInfo();
        String idcard = vo.getIdcard();
        boolean validCard = IdcardUtil.isValidCard((String)idcard);
        Integer sex = validCard ? Integer.valueOf(IdcardUtil.getGenderByIdCard((String)idcard)) : vo.getSex();
        Integer age = validCard ? Integer.valueOf(IdcardUtil.getAgeByIdCard((String)idcard)) : vo.getAge();
        LocalDate birthday = validCard ? LocalDate.from(DateUtil.toLocalDateTime((Date)IdcardUtil.getBirthDate((String)idcard))) : vo.getBirthday();
        entity.setName(vo.getName());
        entity.setPhone(vo.getPhone());
        entity.setIdcardType(vo.getIdcardType());
        entity.setIdcard(idcard);
        entity.setSex(sex);
        entity.setAge(age);
        entity.setBirthday(birthday);
        entity.setSource(StaffSourceEnum.WAND_DOSE.getValue());
        entity.setRaType(vo.getRaType());
        return entity;
    }

    private boolean canSync(CStaffInfoSyncVo vo) {
        boolean flag = true;
        if (StrUtil.isBlank((CharSequence)vo.getName())) {
            flag = false;
        }
        if (StrUtil.isBlank((CharSequence)vo.getIdcard())) {
            flag = false;
        }
        return flag;
    }

    public void syncWandaStaffDataBySql(WandaSyncParam wandaSyncParam) {
        this.staffBaseInfoService.insertStaffBaseInfoFromHC(wandaSyncParam);
    }

    public WandaStaffBaseInfoSyncDoseManager(ICStaffBaseInfoService staffBaseInfoService, RedissonClient redissonClient) {
        this.staffBaseInfoService = staffBaseInfoService;
        this.redissonClient = redissonClient;
    }
}

