/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.staff;

import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class WandaHcStaffRelationSyncManager {
    private static final Logger log = LoggerFactory.getLogger(WandaHcStaffRelationSyncManager.class);
    private final IBCompanyService companyService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final ICHealthCheckDataService healthCheckDataService;
    private final RedissonClient redissonClient;
    @Autowired
    private ApplicationContext applicationContext;
    private static final String LOCK_KEY = "WandaHcStaffRelationSyncManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncWandaStaffData(WandaSyncParam param) {
        log.debug("\u4eba\u5458\u540c\u6b65\uff1a syncWandaStaffData() start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_syncWandaStaffData");
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.syncWandaStaffDataLock(param);
                log.debug("wanda\u4eba\u5458\u540c\u4e0e\u4f53\u68c0\u6570\u636e\u5173\u8054\uff1a syncWandaStaffData() end");
            }
            catch (Exception e) {
                log.error("wanda\u4eba\u5458\u540c\u4e0e\u4f53\u68c0\u6570\u636e\u5173\u8054\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:syncWandaStaffData()", (Object)LOCK_KEY);
        }
    }

    public void syncWandaStaffDataLock(WandaSyncParam param) {
        this.staffBaseInfoService.dealViceDataRelation(param);
    }

    public WandaHcStaffRelationSyncManager(IBCompanyService companyService, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, ICHealthCheckDataService healthCheckDataService, RedissonClient redissonClient) {
        this.companyService = companyService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.healthCheckDataService = healthCheckDataService;
        this.redissonClient = redissonClient;
    }
}

