/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.staff;

import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.uploader.FileResourceEnum;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.entity.sys.SysFile;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.enums.train.TrainingCertAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.train.TrainingCertSourceEnum;
import cn.smarthse.rho.modules.sys.model.c.param.TrainingCertSyncParam;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffFullInfoVo;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.service.sys.ISysFileService;
import cn.smarthse.rho.modules.sys.utils.staff.StaffUniqueReferenceUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.smarthse.framework.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class HSETrainingStaffInfoSyncManager {
    private static final Logger log = LoggerFactory.getLogger(HSETrainingStaffInfoSyncManager.class);
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private ICStaffBaseInfoService staffBaseInfoService;
    @Autowired
    private ICTrainingCertService certService;
    @Autowired
    private ICStaffService staffService;
    @Autowired
    private ISysFileService fileService;

    @Transactional
    public String addOrUpdateForSync(TrainingCertSyncParam param) {
        String checkResult = this.checkSynParam(param);
        if (checkResult != null) {
            return checkResult;
        }
        CStaffBaseInfo staffBaseInfo = StrUtil.isBlank((CharSequence)param.getIdCard()) ? null : this.staffBaseInfoService.getByIdCard(param.getIdCard());
        boolean sbNullFlag = staffBaseInfo == null;
        staffBaseInfo = sbNullFlag ? new CStaffBaseInfo() : staffBaseInfo;
        SysFile file = this.fileService.getTrainingFileBySourceId(param.getSourceFileId());
        if (file == null) {
            file = new SysFile();
            file.setOssUrl(param.getOssUrl()).setSourceId(param.getSourceFileId()).setFileName(param.getFileName()).setFileSize(param.getFileSize()).setFileExt(param.getFileExt()).setFileHash(param.getFileHash()).setResource(Integer.valueOf(FileResourceEnum.radiation_training.getValue())).setCreatorIp(param.getCreatorIp());
            this.fileService.save(file);
        }
        CTrainingCert entityDB = this.certService.getInfoBySourceCertId(param.getSourceCertId());
        BCompany company = (BCompany)this.companyService.getById(param.getCid());
        CTrainingCert entity = new CTrainingCert();
        entity.setId(entityDB == null ? null : entityDB.getId());
        entity.setIdcard(param.getIdCard());
        entity.setSourceTrainingId(param.getSourceTrainingId());
        entity.setSourceEnrollId(param.getSourceEnrollId());
        entity.setSourceCertId(param.getSourceCertId());
        entity.setSourceStaffId(param.getSourceStaffId());
        entity.setCid(param.getCid());
        entity.setCompName(company.getName());
        entity.setStaffBaseInfoId(staffBaseInfo.getId());
        entity.setStaffName(param.getName());
        entity.setTechId(param.getTechId());
        entity.setTechName(param.getTechName());
        entity.setCertType(param.getCertType());
        entity.setCertNo(param.getCertNo());
        entity.setIssuanceDate(param.getIssuanceDate());
        entity.setCertValidDate(param.getCertValidDate() == null ? null : LocalDate.from(param.getCertValidDate()));
        entity.setTrainingName(param.getTrainingName());
        entity.setTrainingBeginDate(param.getTrainingBeginDate());
        entity.setTrainingEndDate(param.getTrainingEndDate());
        entity.setTrainingType(param.getTrainingType());
        entity.setResult(param.getResult());
        entity.setAuditStatus(TrainingCertAuditStatusEnum.NO_AUDIT.getValue());
        entity.setTrainingContent(param.getTrainingContent());
        entity.setTrainingHours(param.getTrainingHours());
        entity.setCertFileId(file.getId());
        entity.setCertFileName(file.getFileName());
        entity.setCertFileUrl(file.getOssUrl());
        entity.setSource(TrainingCertSourceEnum.TRAINING.getValue());
        this.certService.saveOrUpdate(entity);
        return null;
    }

    @Transactional
    public StaffFullInfoVo addStaffInfoForSyncHSETrain(TrainingCertSyncParam param) {
        CStaffBaseInfo staffBaseInfo = this.addStaffBaseInfo(param);
        CStaff staff = this.addStaff(param);
        StaffFullInfoVo staffFullInfoVo = new StaffFullInfoVo();
        staffFullInfoVo.setStaffBaseInfo(staffBaseInfo);
        staffFullInfoVo.setStaff(staff);
        return staffFullInfoVo;
    }

    @Transactional
    public CStaffBaseInfo addStaffBaseInfo(TrainingCertSyncParam param) {
        CStaffBaseInfo db = this.staffBaseInfoService.getOneByIdCard(param.getIdCard());
        if (db != null) {
            return db;
        }
        String idCard = param.getIdCard();
        boolean validCard = IdcardUtil.isValidCard((String)idCard);
        Integer sex = validCard ? Integer.valueOf(IdcardUtil.getGenderByIdCard((String)idCard)) : null;
        Integer age = validCard ? Integer.valueOf(IdcardUtil.getAgeByIdCard((String)idCard)) : null;
        LocalDate birthday = validCard ? LocalDate.ofEpochDay(IdcardUtil.getBirthDate((String)idCard).millisecond()) : null;
        CStaffBaseInfo result = new CStaffBaseInfo();
        result.setName(param.getName());
        result.setIdcard(param.getIdCard());
        result.setSex(sex);
        result.setAge(age);
        result.setBirthday(birthday);
        result.setEditTime(LocalDateTime.now());
        result.setSource(StaffSourceEnum.HSE_TRAIN.getValue());
        this.staffBaseInfoService.save(result);
        return result;
    }

    @Transactional
    public CStaff addStaff(TrainingCertSyncParam param) {
        CStaffBaseInfo staffBaseInfo = this.staffBaseInfoService.getOneByIdCard(param.getIdCard());
        if (staffBaseInfo == null) {
            throw new ServiceException("\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u7f3a\u5931");
        }
        BCompany company = (BCompany)this.companyService.getById(param.getCid());
        CStaff db = this.staffService.getByBaseIdAndBranchCid(staffBaseInfo.getId(), param.getCid());
        if (db != null) {
            return db;
        }
        CStaff staff = new CStaff();
        staff.setBaseId(db.getId());
        staff.setCid(db.getId());
        staff.setStaffType(Integer.valueOf(param.getCertType() == 2 ? 1 : 0));
        staff.setIfRaManager(Integer.valueOf(param.getCertType() == 1 ? 1 : 0));
        staff.setPostStatus(param.getCertType() == 2 ? Integer.valueOf(1) : null);
        staff.setEditTime(LocalDateTime.now());
        staff.setSource(StaffSourceEnum.HSE_TRAIN.getValue());
        staff.setUniqueReference(StaffUniqueReferenceUtil.genUniqueReference((String)company.getCreditCode(), (Long)staffBaseInfo.getId()));
        this.staffService.save(staff);
        return staff;
    }

    private String checkSynParam(TrainingCertSyncParam param) {
        if (param.getSourceTrainingId() == null) {
            return "\u7f3a\u5c11\u57f9\u8badid";
        }
        if (param.getSourceEnrollId() == null) {
            return "\u7f3a\u5c11\u57f9\u8bad\u62a5\u540did";
        }
        if (param.getCid() == null) {
            return "\u7f3a\u5c11\u9662\u533aid";
        }
        if (StrUtil.isBlank((CharSequence)param.getTechName())) {
            return "\u7f3a\u5c11\u53d1\u8bc1\u673a\u6784\u540d\u79f0";
        }
        if (param.getCertType() == null) {
            return "\u7f3a\u5c11\u8bc1\u4e66\u7c7b\u578b";
        }
        if (StrUtil.isBlank((CharSequence)param.getCertNo())) {
            return "\u7f3a\u5c11\u8bc1\u4e66\u7f16\u53f7";
        }
        if (param.getIssuanceDate() == null) {
            return "\u7f3a\u5c11\u53d1\u8bc1\u65e5\u671f";
        }
        if (param.getCertValidDate() == null) {
            return "\u7f3a\u5c11\u8bc1\u4e66\u6709\u6548\u671f";
        }
        if (StrUtil.isBlank((CharSequence)param.getTrainingName())) {
            return "\u7f3a\u5c11\u57f9\u8bad\u540d\u79f0";
        }
        if (param.getTrainingBeginDate() == null) {
            return "\u7f3a\u5c11\u57f9\u8bad\u5f00\u59cb\u65f6\u95f4";
        }
        if (param.getTrainingEndDate() == null) {
            return "\u7f3a\u5c11\u57f9\u8bad\u7ed3\u675f\u65f6\u95f4";
        }
        if (param.getTrainingType() == null) {
            return "\u7f3a\u5c11\u57f9\u8bad\u7c7b\u578b";
        }
        if (param.getResult() == null) {
            return "\u7f3a\u5c11\u57f9\u8bad\u7ed3\u679c";
        }
        if (param.getTrainingHours() == null) {
            return "\u7f3a\u5c11\u57f9\u8bad\u5b66\u89c6";
        }
        if (param.getCid() == null) {
            return "\u7f3a\u5c11\u533b\u9662id";
        }
        BCompany company = (BCompany)this.companyService.getById(param.getCid());
        if (company == null) {
            return "\u533b\u9662\u4e0d\u5b58\u5728";
        }
        if (StrUtil.isBlank((CharSequence)param.getOssUrl())) {
            return "\u7f3a\u5931\u8bc1\u4e66\u6587\u4ef6";
        }
        if (param.getSourceFileId() == null) {
            return "\u7f3a\u5931\u8bc1\u4e66\u6587\u4ef6id";
        }
        if (StrUtil.isBlank((CharSequence)param.getFileHash())) {
            return "\u7f3a\u5931\u8bc1\u4e66hash";
        }
        return null;
    }
}

