/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk;

import cn.smarthse.rho.modules.sys.enums.risk.RiskSourceEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.g.IGProtectiveEquipmentService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskGenProtectiveEquipmentManager {
    private static final Logger log = LoggerFactory.getLogger(RiskGenProtectiveEquipmentManager.class);
    private final RedissonClient redissonClient;
    @DubboReference
    private IRiskProvider riskProvider;
    @DubboReference
    private IGProtectiveEquipmentService gProtectiveEquipmentService;
    private static final String LOCK_KEY = "RiskGenProtectiveEquipmentManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genProtectiveEquipmentRisk() {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u81ea\u68c0\u9884\u8b66";
        String methodName = "genProtectiveEquipmentRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_genProtectiveEquipmentRisk");
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.genProtectiveEquipmentRiskLock();
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genProtectiveEquipmentRiskLock() {
        List<Long> cidList = this.gProtectiveEquipmentService.selectNeedToGenRiskId();
        ArrayList<AddRiskForCommonParam> parmList = new ArrayList<AddRiskForCommonParam>();
        for (Long cid : cidList) {
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(null);
            genParam.setSubBusinessId(null);
            genParam.setName("\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u81ea\u68c0\u5373\u5c06\u5931\u6548");
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setType(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue());
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(LocalDate.now());
            genParam.setExpireTime(null);
            genParam.setRequireFinishTime(null);
            genParam.setIsGenerateByData(Integer.valueOf(0));
            parmList.add(genParam);
            if (parmList.size() <= 500) continue;
            try {
                this.riskProvider.genRiskOfCommon(parmList);
            }
            catch (Exception e) {
                log.error("\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u81ea\u68c0\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
            }
            finally {
                parmList.clear();
            }
        }
        this.riskProvider.genRiskOfCommon(parmList);
    }

    public RiskGenProtectiveEquipmentManager(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

