/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.risk.RiskSourceEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffTypeEnum;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.r.vo.CalculateVo;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCertService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.service.e.IEDeviceCommonService;
import cn.smarthse.rho.modules.sys.service.e.IEMachineRoomCommonService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class RiskGenHCManager {
    private static final Logger log = LoggerFactory.getLogger(RiskGenHCManager.class);
    private final ICHealthCheckDataService healthCheckDataService;
    private final ICTrainingCertService trainingCertService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final ICDoseDataService doseDataService;
    private final IBCompanyService companyService;
    private final ISysAreaService areaService;
    private final IBCertService cmCertService;
    private final IEDeviceCommonService deviceService;
    private final IEMachineRoomCommonService machineRoomService;
    private final ApplicationContext applicationContext;
    private final RedissonClient redissonClient;
    @DubboReference
    private IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genHCRisk(RiskMangerGenParam param) {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u4f53\u68c0\u98ce\u9669-\u751f\u6210";
        String methodName = "genHCRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear()).append(param.getThirdLevelAreaId());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.genHCRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    public void genHCRiskLock(RiskMangerGenParam param) {
        List<CStaffBaseInfo> entityList = this.staffBaseInfoService.getListForGenHcRisk(param);
        ArrayList<AddRiskForCommonParam> genListParam = new ArrayList<AddRiskForCommonParam>();
        for (CStaffBaseInfo entity : entityList) {
            CHealthCheckData lastData = this.healthCheckDataService.getLastHealthCheckData(entity.getId());
            if (lastData != null) {
                this.genHasDataInfo(entity, lastData, genListParam);
                continue;
            }
            this.genNonDataInfo(entity, genListParam);
        }
        try {
            if (CollUtil.isNotEmpty(genListParam)) {
                this.riskProvider.genRiskOfCommon(genListParam);
            }
        }
        catch (Exception e) {
            log.error("\u8bb8\u53ef\u8bc1\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genHasDataInfo(CStaffBaseInfo entity, CHealthCheckData lastData, List<AddRiskForCommonParam> genListParam) {
        CalculateVo calculate = this.healthCheckDataService.calculate(lastData);
        if (calculate == null) {
            log.error("\u4f53\u68c0\u98ce\u9669\u751f\u6210\u3010\u6709\u6570\u636e\u60c5\u51b5\u3011\u3010\u6574\u4f53\u3011\u8ba1\u7b97\u5931\u8d25:{}", (Object)lastData.getId());
            return;
        }
        LocalDateTime expireTime = calculate.getExpireTime();
        Integer warnType = calculate.getWarningType();
        if (expireTime == null) {
            log.error("\u4f53\u68c0\u98ce\u9669\u751f\u6210\u3010\u6709\u6570\u636e\u60c5\u51b5\u3011\u3010\u8fc7\u671f\u65f6\u95f4\u3011\u8ba1\u7b97\u5931\u8d25:{}", (Object)lastData.getId());
            return;
        }
        if (warnType == null) {
            log.error("\u4f53\u68c0\u98ce\u9669\u751f\u6210\u3010\u6709\u6570\u636e\u60c5\u51b5\u3011\u3010\u9884\u8b66\u7c7b\u578b\u3011\u8ba1\u7b97\u5931\u8d25:{}", (Object)lastData.getId());
            return;
        }
        if (warnType.equals(RiskWarningStatusEnum.NONE.getValue())) {
            return;
        }
        List<Long> cidList = this.staffBaseInfoService.getCidList(entity.getId(), PostStatusEnum.ON_POST.getValue(), StaffTypeEnum.RAY.getValue());
        for (Long cid : cidList) {
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(lastData.getId());
            genParam.setSubBusinessId(lastData.getStaffBaseInfoId());
            genParam.setName(null);
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setType(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue());
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(LocalDate.from(calculate.getStartTime()));
            genParam.setExpireTime(LocalDate.from(calculate.getExpireTime()));
            genParam.setRequireFinishTime(null);
            genParam.setIsGenerateByData(Integer.valueOf(1));
            genListParam.add(genParam);
        }
        if (genListParam.size() >= 500) {
            try {
                this.riskProvider.genRiskOfCommon(genListParam);
            }
            catch (Exception e) {
                log.error("\u8bb8\u53ef\u8bc1\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
            }
            finally {
                genListParam.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genNonDataInfo(CStaffBaseInfo entity, List<AddRiskForCommonParam> genListParam) {
        CalculateVo calculate = this.healthCheckDataService.calculate2(entity);
        if (calculate == null) {
            log.error("\u4f53\u68c0\u98ce\u9669\u751f\u6210\u3010\u65e0\u6570\u636e\u60c5\u51b5\u3011\u3010\u6574\u4f53\u3011\u8ba1\u7b97\u5931\u8d25:{}", (Object)entity.getId());
            return;
        }
        if (calculate.getStartTime() == null) {
            log.error("\u4f53\u68c0\u98ce\u9669\u751f\u6210\u3010\u65e0\u6570\u636e\u60c5\u51b5\u3011\u3010\u8d77\u59cb\u65f6\u95f4\u3011\u8ba1\u7b97\u5931\u8d25:{}", (Object)entity.getId());
            return;
        }
        List<Long> cidList = this.staffBaseInfoService.getCidList(entity.getId(), PostStatusEnum.ON_POST.getValue(), StaffTypeEnum.RAY.getValue());
        for (Long cid : cidList) {
            AddRiskForCommonParam genParam = new AddRiskForCommonParam();
            genParam.setCid(cid);
            genParam.setThirdOrgId(null);
            genParam.setBusinessId(entity.getId());
            genParam.setSubBusinessId(entity.getId());
            genParam.setName(null);
            genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
            genParam.setType(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue());
            genParam.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            genParam.setDescription(null);
            genParam.setFiles(null);
            genParam.setStartTime(LocalDate.from(calculate.getStartTime()));
            genParam.setExpireTime(null);
            genParam.setRequireFinishTime(null);
            genParam.setIsGenerateByData(Integer.valueOf(0));
            genListParam.add(genParam);
        }
        if (genListParam.size() >= 500) {
            try {
                this.riskProvider.genRiskOfCommon(genListParam);
            }
            catch (Exception e) {
                log.error("\u8bb8\u53ef\u8bc1\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
            }
            finally {
                genListParam.clear();
            }
        }
    }

    public RiskGenHCManager(ICHealthCheckDataService healthCheckDataService, ICTrainingCertService trainingCertService, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, ICDoseDataService doseDataService, IBCompanyService companyService, ISysAreaService areaService, IBCertService cmCertService, IEDeviceCommonService deviceService, IEMachineRoomCommonService machineRoomService, ApplicationContext applicationContext, RedissonClient redissonClient) {
        this.healthCheckDataService = healthCheckDataService;
        this.trainingCertService = trainingCertService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.doseDataService = doseDataService;
        this.companyService = companyService;
        this.areaService = areaService;
        this.cmCertService = cmCertService;
        this.deviceService = deviceService;
        this.machineRoomService = machineRoomService;
        this.applicationContext = applicationContext;
        this.redissonClient = redissonClient;
    }
}

