/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.risk;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.model.r.param.RiskManagerDefuseParam;
import cn.smarthse.rho.modules.sys.model.r.vo.CalculateVo;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCertService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskDefuseHCManager {
    private static final Logger log = LoggerFactory.getLogger(RiskDefuseHCManager.class);
    private final IBCertService cmCertService;
    private final RedissonClient redissonClient;
    private final IRiskBasicSourceCommonService riskSourceService;
    private final ICHealthCheckDataService healthCheckDataService;
    @DubboReference
    private IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defuseHCRisk(RiskManagerDefuseParam param) {
        String title = "\u98ce\u9669\u7ef4\u62a4\uff1a\u4f53\u68c0-\u5316\u89e3";
        String methodName = "defuseHCRisk()";
        log.debug(title + methodName + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_").append(methodName).append("_").append(param.getYear());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.defuseHCRiskLock(param);
                log.debug(title + methodName + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defuseHCRiskLock(RiskManagerDefuseParam param) {
        List<RRiskBasicSource> list = this.riskSourceService.getHealthCheckRiskForManager(param);
        ArrayList<Long> riskSourceIdList = new ArrayList<Long>();
        for (RRiskBasicSource vo : list) {
            if (vo.getSubBusinessId() == null) {
                log.error("\u4f53\u68c0\u98ce\u9669\u5316\u89e3\uff1a\u7f3a\u5c11subBusinessId\u4eba\u5458id:{}", (Object)vo.getId());
                continue;
            }
            CHealthCheckData db = this.healthCheckDataService.getLastHealthCheckData(vo.getSubBusinessId());
            if (db == null) continue;
            CalculateVo calculate = this.healthCheckDataService.calculate(db);
            if (calculate == null) {
                log.error("\u4f53\u68c0\u98ce\u9669\u5316\u89e3\u3010\u6574\u4f53\u3011\u8ba1\u7b97\u5931\u8d25:{}", (Object)vo.getId());
                continue;
            }
            Integer warningType = calculate.getWarningType();
            if (warningType == null) {
                log.error("\u4f53\u68c0\u98ce\u9669\u5316\u89e3\u3010\u9884\u8b66\u7c7b\u578b\u3011\u8ba1\u7b97\u5931\u8d25:{}", (Object)vo.getId());
                continue;
            }
            if (warningType.equals(RiskWarningStatusEnum.NONE.getValue())) {
                riskSourceIdList.add(vo.getId());
            }
            if (riskSourceIdList.size() < 500) continue;
            try {
                this.riskProvider.resolveRiskOfCommon(riskSourceIdList);
            }
            catch (Exception e) {
                log.error("\u8bb8\u53ef\u8bc1\u98ce\u9669\u5316\u89e3\u5931\u8d25");
            }
            finally {
                riskSourceIdList.clear();
            }
        }
        try {
            if (CollUtil.isNotEmpty(riskSourceIdList)) {
                this.riskProvider.resolveRiskOfCommon(riskSourceIdList);
            }
        }
        catch (Exception e) {
            log.error("\u8bb8\u53ef\u8bc1\u98ce\u9669\u5316\u89e3\u5931\u8d25");
        }
    }

    public RiskDefuseHCManager(IBCertService cmCertService, RedissonClient redissonClient, IRiskBasicSourceCommonService riskSourceService, ICHealthCheckDataService healthCheckDataService) {
        this.cmCertService = cmCertService;
        this.redissonClient = redissonClient;
        this.riskSourceService = riskSourceService;
        this.healthCheckDataService = healthCheckDataService;
    }
}

