/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.license;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.smarthse.core.framework.utils.login.JwtUtil;
import cn.smarthse.rho.modules.sys.entity.b.BCert;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.b.BCycleLicense;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.e.EMachineRoom;
import cn.smarthse.rho.modules.sys.model.b.param.license.BCycleLicenseBatchGenParam;
import cn.smarthse.rho.modules.sys.model.b.param.license.BCycleLicenseGenParam;
import cn.smarthse.rho.modules.sys.model.b.param.license.LicenseCycleParam;
import cn.smarthse.rho.modules.sys.service.b.IBCertService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.b.IBCycleLicenseService;
import cn.smarthse.rho.modules.sys.service.e.IEDeviceCommonService;
import cn.smarthse.rho.modules.sys.service.e.IEMachineRoomCommonService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CycleLicenseManager {
    private static final Logger log = LoggerFactory.getLogger(CycleLicenseManager.class);
    @Autowired
    private IBCycleLicenseService cycleLicenseService;
    @Autowired
    @Lazy
    private CycleLicenseManager self;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IEDeviceCommonService deviceService;
    @Autowired
    private IEMachineRoomCommonService machineRoomService;
    @Autowired
    private IBCertService cmCertService;
    @Autowired
    private IEMachineRoomCommonService roomService;

    @Transactional
    public void licenseCycleBatch(LicenseCycleParam param) {
        if (CollUtil.isEmpty((Collection)param.getIdList())) {
            return;
        }
        for (Long id : param.getIdList()) {
            LicenseCycleParam subParam = new LicenseCycleParam();
            subParam.setId(id);
            subParam.setLicenseResult(param.getLicenseResult());
            this.self.licenseCycle(subParam);
        }
    }

    @Transactional
    public void licenseCycle(LicenseCycleParam param) {
        BCycleLicense db = null;
        Object company = null;
        if (param.getId() == null || param.getLicenseResult() == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (param.getLicenseResult() != 0 || param.getLicenseResult() != 1) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        db = (BCycleLicense)this.cycleLicenseService.getById(param.getId());
        if (db == null) {
            throw new ServiceException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        BCycleLicense upEntity = new BCycleLicense();
        upEntity.setId(param.getId());
        upEntity.setAdminLicenseStatus(param.getLicenseResult());
        upEntity.setAdminLicenseTime(LocalDateTime.now());
        upEntity.setAdminLicenseId(JwtUtil.getUserId());
        this.cycleLicenseService.updateById(upEntity);
    }

    public void genCycleLicenseBatch(List<BCycleLicenseBatchGenParam> batchGenParamList) {
        for (BCycleLicenseBatchGenParam batchParam : batchGenParamList) {
            List<EDevice> deviceList = this.deviceService.getForCycleLicense(batchParam.getCid());
            for (EDevice device : deviceList) {
                BCycleLicenseGenParam param = new BCycleLicenseGenParam();
                param.setCid(batchParam.getCid());
                param.setDeviceId(device.getId());
                param.setDeductionExpiredDate(batchParam.getDeductionExpiredDate());
                try {
                    this.self.genCycleLicense(param);
                }
                catch (Exception e) {
                    log.error("\u751f\u6210\u8bb8\u53ef\u6821\u9a8c\u5931\u8d25\uff0c\u516c\u53f8{}\uff0c\u8bbe\u5907{},exception{}", new Object[]{param.getCid(), param.getDeviceId(), e});
                }
            }
        }
    }

    public void genCycleLicense(BCycleLicenseGenParam param) {
        if (param.getDeviceId() == null || param.getCid() == null || param.getDeductionExpiredDate() == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        Long deviceId = param.getDeviceId();
        Long cid = param.getCid();
        BCompany dbCompany = null;
        BCert dbCmCert = null;
        EDevice dbDevice = null;
        EMachineRoom dbRoom = null;
        BCycleLicense db = null;
        dbCompany = (BCompany)this.companyService.getById(cid);
        if (dbCompany == null) {
            throw new ServiceException("\u516c\u53f8\u4e0d\u5b58\u5728");
        }
        dbCmCert = this.cmCertService.getByCid(cid);
        if (dbCmCert == null) {
            return;
        }
        dbDevice = (EDevice)this.deviceService.getById(deviceId);
        if (dbDevice == null) {
            throw new ServiceException("\u8bbe\u5907\u4e0d\u5b58\u5728");
        }
        db = this.cycleLicenseService.getForGenCycleLicense(dbDevice.getId(), param.getDeductionExpiredDate());
        if (db != null) {
            throw new ServiceException("\u5df2\u5b58\u5728\u5468\u671f\u6027\u6821\u9a8c\u6570\u636e");
        }
        dbRoom = (EMachineRoom)this.roomService.getById(dbDevice.getLocationId());
        dbRoom = dbRoom == null ? new EMachineRoom() : dbRoom;
        BCycleLicense cycleLicense = new BCycleLicense().setCid(cid).setDeviceId(deviceId).setDeviceType(dbDevice.getType()).setDeviceName(dbDevice.getName()).setDeviceNo(dbDevice.getFactoryNo()).setPlaceId(dbDevice.getLocationId()).setPlaceName(dbRoom.getName()).setDeductionExpiredDate(LocalDate.from(param.getDeductionExpiredDate())).setCertLastVerificationDate(LocalDate.from(dbCmCert.getLastVerificationDate())).setCertBeginDate(LocalDate.from(dbCmCert.getBeginDate())).setCertEndDate(LocalDate.from(dbCmCert.getEndDate())).setCertId(dbCmCert.getId()).setCertSourceId(dbCmCert.getSourceId()).setCertSource(dbCmCert.getSource()).setAdminLicenseStatus(null).setYear(Integer.valueOf(DateUtil.year((Date)new Date())));
        this.cycleLicenseService.save(cycleLicense);
    }
}

