/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.license;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.utils.ChangeLicenseUtil;
import cn.smarthse.core.framework.utils.login.JwtUtil;
import cn.smarthse.rho.modules.sys.entity.b.BChangeLicense;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.e.EMachineRoom;
import cn.smarthse.rho.modules.sys.enums.license.AdminLicenseStatusEnum;
import cn.smarthse.rho.modules.sys.enums.license.LicenseChangeTypeEnum;
import cn.smarthse.rho.modules.sys.model.b.param.license.LicenseChangeParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.service.b.IBChangeLicenseService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.e.IEDeviceCommonService;
import cn.smarthse.rho.modules.sys.service.e.IEMachineRoomCommonService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ChangeLicenseManager {
    @Autowired
    private IBChangeLicenseService changeLicenseService;
    @Autowired
    private ISysAreaService areaService;
    @Autowired
    @Lazy
    private ChangeLicenseManager self;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IEDeviceCommonService deviceService;
    @Autowired
    private IEMachineRoomCommonService machineRoomService;

    public void licenseChange(LicenseChangeParam param) {
        if (param.getId() == null || param.getLicenseResult() == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (param.getLicenseResult() != 0 && param.getLicenseResult() != 1) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        BChangeLicense db = (BChangeLicense)this.changeLicenseService.getById(param.getId());
        if (db == null) {
            throw new ServiceException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (db.getNeedLicense() == 0) {
            throw new ServiceException("\u65e0\u9700\u8bb8\u53ef");
        }
        BCompany company = (BCompany)this.companyService.getById(db.getTargetId());
        if (company == null) {
            throw new ServiceException("\u9662\u533a\u4e0d\u5b58\u5728");
        }
        String subType = db.getSubType();
        Integer licenseResult = param.getLicenseResult();
        if (!db.getAdminLicenseStatus().equals(AdminLicenseStatusEnum.NOT_PERMITTED.getStatus())) {
            return;
        }
        if (licenseResult == 1) {
            if (subType.equals(LicenseChangeTypeEnum.CHANGE_UNIT_NAME.getSubType())) {
                this.self.licenseChangeForUnitName(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_UNIT_ADDRESS.getSubType())) {
                this.self.licenseChangeForUnitAddress(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_UNIT_LEGAL.getSubType())) {
                this.self.licenseChangeForUnitLegal(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_UNIT_LEADER.getSubType())) {
                this.self.licenseChangeForUnitLeader(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_ADD.getSubType())) {
                this.self.licenseChangeForDeviceAdd(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_SUB.getSubType())) {
                this.self.licenseChangeForDeviceSub(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_PLACE.getSubType())) {
                this.self.licenseChangeForDevicePlace(param);
            } else if (subType.equals(LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_PROJECT.getSubType())) {
                this.self.licenseChangeForDevicePlace(param);
            }
        }
        BChangeLicense upEntity = new BChangeLicense();
        upEntity.setId(db.getId());
        upEntity.setAdminLicenseStatus(param.getLicenseResult() == 0 ? AdminLicenseStatusEnum.NOT_PERMITTED.getStatus() : AdminLicenseStatusEnum.PERMITTED.getStatus());
        upEntity.setAdminLicenseId(JwtUtil.getUserId());
        upEntity.setAdminLicenseId(JwtUtil.getUserId());
        this.changeLicenseService.updateById(upEntity);
    }

    public void licenseChangeForUnitName(LicenseChangeParam param) {
        if (param.getLicenseResult() == 0) {
            return;
        }
        BChangeLicense db = (BChangeLicense)this.changeLicenseService.getById(param.getId());
        if (StrUtil.isBlank((CharSequence)db.getAfterValue())) {
            throw new ServiceException("\u53d8\u66f4\u5355\u4f4d\u540d\u79f0\u4e0d\u5b58\u5728");
        }
        BCompany cmUpEntity = new BCompany();
        cmUpEntity.setId(db.getTargetId());
        cmUpEntity.setName(db.getAfterValue());
        this.companyService.updateById(cmUpEntity);
    }

    public void licenseChangeForUnitAddress(LicenseChangeParam param) {
        Object company = null;
        SysAreaVo area = null;
        BChangeLicense db = null;
        List afterValueList = null;
        if (param.getLicenseResult() == 0) {
            return;
        }
        db = (BChangeLicense)this.changeLicenseService.getById(param.getId());
        if (StrUtil.isBlank((CharSequence)db.getAfterValue())) {
            throw new ServiceException("\u53d8\u66f4\u5355\u4f4d\u5730\u5740\u4e0d\u5b58\u5728");
        }
        afterValueList = ChangeLicenseUtil.genValueList((String)db.getAfterValue());
        if (afterValueList.size() == 1) {
            throw new ServiceException("\u53d8\u66f4\u5355\u4f4d\u5730\u5740\u4e0d\u5b8c\u6574");
        }
        if (!NumberUtil.isNumber((CharSequence)((CharSequence)afterValueList.get(0)))) {
            throw new ServiceException("\u53d8\u66f4\u5355\u4f4d\u5730\u5740\u683c\u5f0f\u9519\u8bef");
        }
        area = this.areaService.getAreaById(Long.valueOf((String)afterValueList.get(0)));
        if (area == null) {
            throw new ServiceException("\u53d8\u66f4\u5355\u4f4d\u5730\u5740\u4e0d\u5b58\u5728");
        }
        BCompany cmUpEntity = new BCompany();
        cmUpEntity.setId(db.getTargetId());
        cmUpEntity.setAreaId(area.getId());
        cmUpEntity.setAddress((String)afterValueList.get(1));
        this.companyService.updateById(cmUpEntity);
    }

    public void licenseChangeForUnitLegal(LicenseChangeParam param) {
        Object company = null;
        Object area = null;
        BChangeLicense db = null;
        List afterValueList = null;
        if (param.getLicenseResult() == 0) {
            return;
        }
        db = (BChangeLicense)this.changeLicenseService.getById(param.getId());
        if (StrUtil.isBlank((CharSequence)db.getAfterValue())) {
            throw new ServiceException("\u65e0\u6cd5\u83b7\u53d6\u53d8\u66f4\u540e\u6cd5\u5b9a\u4ee3\u8868\u4eba\u4fe1\u606f");
        }
        afterValueList = ChangeLicenseUtil.genValueList((String)db.getAfterValue());
        if (afterValueList.size() == 1) {
            throw new ServiceException("\u6cd5\u5b9a\u4ee3\u8868\u4eba\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
        BCompany cmUpEntity = new BCompany();
        cmUpEntity.setId(db.getTargetId());
        cmUpEntity.setLegalName((String)afterValueList.get(0));
        cmUpEntity.setLegalTel((String)afterValueList.get(1));
        this.companyService.updateById(cmUpEntity);
    }

    public void licenseChangeForUnitLeader(LicenseChangeParam param) {
        Object company = null;
        Object area = null;
        BChangeLicense db = null;
        List afterValueList = null;
        if (param.getLicenseResult() == 0) {
            return;
        }
        db = (BChangeLicense)this.changeLicenseService.getById(param.getId());
        if (StrUtil.isBlank((CharSequence)db.getAfterValue())) {
            throw new ServiceException("\u65e0\u6cd5\u83b7\u53d6\u53d8\u66f4\u540e\u7684\u4e3b\u8981\u8d1f\u8d23\u4eba\u4fe1\u606f");
        }
        afterValueList = ChangeLicenseUtil.genValueList((String)db.getAfterValue());
        if (afterValueList.size() == 1) {
            throw new ServiceException("\u4e3b\u8981\u8d1f\u8d23\u4eba\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
        BCompany cmUpEntity = new BCompany();
        cmUpEntity.setId(db.getTargetId());
        cmUpEntity.setMainLeaderName((String)afterValueList.get(0));
        cmUpEntity.setMainLeaderTel((String)afterValueList.get(1));
        this.companyService.updateById(cmUpEntity);
    }

    public void licenseChangeForDeviceAdd(LicenseChangeParam param) {
        Object company = null;
        EDevice device = null;
        Object area = null;
        BChangeLicense db = null;
        Object afterValueList = null;
        if (param.getLicenseResult() == 0) {
            return;
        }
        db = (BChangeLicense)this.changeLicenseService.getById(param.getId());
        device = (EDevice)this.deviceService.getById(db.getTargetId());
        if (device == null) {
            throw new ServiceException("\u8bbe\u5907\u4e0d\u5b58\u5728");
        }
        EDevice deviceUpEntity = new EDevice();
        deviceUpEntity.setId(db.getTargetId());
        this.deviceService.updateById(deviceUpEntity);
    }

    public void licenseChangeForDeviceSub(LicenseChangeParam param) {
        Object company = null;
        EDevice device = null;
        Object area = null;
        BChangeLicense db = null;
        Object afterValueList = null;
        if (param.getLicenseResult() == 0) {
            return;
        }
        db = (BChangeLicense)this.changeLicenseService.getById(param.getId());
        device = (EDevice)this.deviceService.getById(db.getTargetId());
        if (device == null) {
            throw new ServiceException("\u8bbe\u5907\u4e0d\u5b58\u5728");
        }
        EDevice deviceUpEntity = new EDevice();
        deviceUpEntity.setId(db.getTargetId());
        this.deviceService.updateById(deviceUpEntity);
    }

    public void licenseChangeForDevicePlace(LicenseChangeParam param) {
        Object company = null;
        EDevice device = null;
        EMachineRoom machineRoom = null;
        Object area = null;
        BChangeLicense db = null;
        Object afterValueList = null;
        if (param.getLicenseResult() == 0) {
            return;
        }
        db = (BChangeLicense)this.changeLicenseService.getById(param.getId());
        device = (EDevice)this.deviceService.getById(db.getTargetId());
        if (device == null) {
            throw new ServiceException("\u8bbe\u5907\u4e0d\u5b58\u5728");
        }
        if (StrUtil.isBlank((CharSequence)db.getAfterValue())) {
            throw new ServiceException("\u53d8\u66f4\u540e\u83b7\u53d6\u573a\u6240\u9519\u8bef");
        }
        if (!NumberUtil.isNumber((CharSequence)db.getAfterValue())) {
            throw new ServiceException("\u65e0\u6cd5\u83b7\u53d6\u573a\u6240\u4fe1\u606f");
        }
        machineRoom = (EMachineRoom)this.machineRoomService.getById(Long.valueOf(db.getAfterValue()));
        if (machineRoom == null) {
            throw new ServiceException("\u573a\u6240\u4e0d\u5b58\u5728");
        }
        EDevice deviceUpEntity = new EDevice();
        deviceUpEntity.setId(db.getTargetId());
        this.deviceService.updateById(deviceUpEntity);
    }
}

