/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.hc;

import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaHealthDataSyncParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WandaFswsHCCompanyRelationSyncManager {
    private static final Logger log = LoggerFactory.getLogger(WandaFswsHCCompanyRelationSyncManager.class);
    private final ICHealthCheckDataService healthCheckDataService;
    private final RedissonClient redissonClient;
    private final IBCompanyService companyService;
    private static final String LOCK_KEY = "WandaFswsHCContactFactorsSyncManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncRelationInfo(WandaHealthDataSyncParam param) {
        log.debug("wanda \u4f53\u68c0\u6570\u636e\u5173\u8054\u9662\u533a\uff1a syncRelationInfo() start");
        boolean flag = false;
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_syncBaseInfoData");
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(240L, 240L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.syncRelationInfoLock(param);
                log.debug("wanda \u4f53\u68c0\u6570\u636e\u5173\u8054\u9662\u533a\uff1a syncRelationInfo() end");
                flag = true;
            }
            catch (Exception e) {
                log.error("wanda \u4f53\u68c0\u6570\u636e\u5173\u8054\u9662\u533a\u5931\u8d25\uff1a{}", (Throwable)e);
                flag = false;
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:syncRelationInfo()", (Object)LOCK_KEY);
            flag = false;
        }
        return flag;
    }

    public void syncRelationInfoLock(WandaHealthDataSyncParam param) {
        this.healthCheckDataService.dealCompanyRelation(param);
    }

    public WandaFswsHCCompanyRelationSyncManager(ICHealthCheckDataService healthCheckDataService, RedissonClient redissonClient, IBCompanyService companyService) {
        this.healthCheckDataService = healthCheckDataService;
        this.redissonClient = redissonClient;
        this.companyService = companyService;
    }
}

