/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.company;

import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.manger.company.WandaCmOtherManager;
import cn.smarthse.rho.modules.sys.model.b.param.CompanySyncParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WandaCmSyncManager {
    private static final Logger log = LoggerFactory.getLogger(WandaCmSyncManager.class);
    private final IBCompanyService companyService;
    private final ISysAreaService areaService;
    private final ISysUserService sysUserService;
    private final WandaCmOtherManager otherManager;
    private final RedissonClient redissonClient;
    @Autowired
    private ApplicationContext applicationContext;
    private static final String LOCK_KEY = "WandaCmSyncManager";
    private static final String MEDICAL_COMPANY_URL = "https://jmzk.wsjkw.zj.gov.cn:8001/wdrc/dataQueryService";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public boolean registerAccount(CompanySyncParam param) {
        log.debug("wanda\u533b\u9662\u540c\u6b65\uff1a registerAccount() start");
        boolean flag = false;
        WandaCmSyncManager self = (WandaCmSyncManager)this.applicationContext.getBean(WandaCmSyncManager.class);
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_registerAccount");
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                self.registerAccountLock(param);
                log.debug("wanda\u533b\u9662\u8d26\u53f7\u6ce8\u518c\uff1a registerAccount() end");
                flag = true;
            }
            catch (Exception e) {
                log.error("wanda\u533b\u9662\u8d26\u53f7\u6ce8\u518c\u5931\u8d25\uff1a{}", (Throwable)e);
                flag = false;
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:registerAccount()", (Object)LOCK_KEY);
            flag = false;
        }
        return flag;
    }

    @Transactional
    public void registerAccountLock(CompanySyncParam param) {
        List<BCompany> entitList = this.companyService.getNeedRegisterAccountForWanda(param);
        for (BCompany company : entitList) {
            this.sysUserService.addUserForWanda(company.getId(), company.getName(), 1234563L, company.getMedicalNucode());
        }
    }

    public WandaCmSyncManager(IBCompanyService companyService, ISysAreaService areaService, ISysUserService sysUserService, WandaCmOtherManager otherManager, RedissonClient redissonClient) {
        this.companyService = companyService;
        this.areaService = areaService;
        this.sysUserService = sysUserService;
        this.otherManager = otherManager;
        this.redissonClient = redissonClient;
    }
}

