/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.company;

import cn.smarthse.rho.modules.sys.model.b.param.CompanySyncParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class WandaCmOtherManager {
    private static final Logger log = LoggerFactory.getLogger(WandaCmOtherManager.class);
    private final IBCompanyService companyService;
    private final RedissonClient redissonClient;
    @Autowired
    private ApplicationContext applicationContext;
    private static final String LOCK_KEY = "WandaCmOtherManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public boolean initHospitalName(CompanySyncParam param) {
        log.debug("\u533b\u9662\u6240\u5728\u533b\u9662\u521d\u59cb\u5316\uff1a initHospitalName() start");
        boolean flag = false;
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_initHospitalName");
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.companyService.initHospitalName(param);
                log.debug("\u533b\u9662\u6240\u5728\u533b\u9662\u521d\u59cb\u5316\uff1a initHospitalName() end");
                flag = true;
            }
            catch (Exception e) {
                log.error("\u533b\u9662\u6240\u5728\u533b\u9662\u521d\u59cb\u5316\uff1a{}", (Throwable)e);
                flag = false;
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:initHospitalName()", (Object)LOCK_KEY);
            flag = false;
        }
        return flag;
    }

    public WandaCmOtherManager(IBCompanyService companyService, RedissonClient redissonClient) {
        this.companyService = companyService;
        this.redissonClient = redissonClient;
    }
}

