/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.company;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.enums.company.BusinessStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.manger.staff.StaffEditManager;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyAdminEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffBaseInfoEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffEditParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import java.time.LocalDateTime;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class CompanyEditManager {
    private static final Logger log = LoggerFactory.getLogger(CompanyEditManager.class);
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private ICStaffBaseInfoService staffBaseInfoService;
    @Autowired
    private ICStaffService staffService;
    @Autowired
    private ISysAreaService sysAreaService;
    @Autowired
    private StaffEditManager staffEditManager;
    @Autowired
    private RedissonClient redissonClient;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;

    @Transactional
    public void addInfo(BCompanyAdminEditParam param) {
        this.trim(param);
        String name = param.getName();
        String creditCode = param.getCreditCode();
        String medicalNucode = param.getMedicalNucode();
        if (StrUtil.isBlank((CharSequence)name)) {
            throw new ServiceException("\u8bf7\u586b\u5199\u533b\u9662\u540d\u79f0");
        }
        if (StrUtil.isBlank((CharSequence)creditCode)) {
            throw new ServiceException("\u8bf7\u586b\u5199\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801");
        }
        if (StrUtil.isBlank((CharSequence)medicalNucode)) {
            throw new ServiceException("\u8bf7\u586b\u5199\u552f\u4e00\u6807\u8bc6\u7801");
        }
        BCompany byName = this.companyService.getByName(name);
        BCompany byMedicalNucode = this.companyService.getByMedicalNucode(medicalNucode);
        if (byName != null) {
            throw new ServiceException("\u9644\u5c5e\u5bf9\u8c61\uff08\u9662\u533a\uff09\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (byMedicalNucode != null) {
            throw new ServiceException("\u552f\u4e00\u6807\u8bc6\u7801\u5df2\u5b58\u5728");
        }
        Organization org = (Organization)this.organizationService.getById(param.getSupervisionUnit());
        if (org == null) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u8be2\u5230\u76d1\u7ba1\u5355\u4f4d");
        }
        BCompany addEntity = new BCompany();
        addEntity.setHospitalName(param.getHospitalName());
        addEntity.setName(name);
        addEntity.setCreditCode(creditCode);
        addEntity.setMedicalNucode(medicalNucode);
        addEntity.setAreaId(param.getAreaId());
        addEntity.setAddress(param.getAddress());
        addEntity.setRegisteredAreaId(param.getRegisteredAreaId());
        addEntity.setRegisteredAddress(param.getRegisteredAddress());
        addEntity.setLegalName(param.getLegalName());
        addEntity.setLegalTel(param.getLegalTel());
        addEntity.setMainLeaderName(param.getMainLeaderName());
        addEntity.setMainLeaderTel(param.getMainLeaderTel());
        addEntity.setBelongType(CompanyBelongTypeEnum.NO.getValue());
        addEntity.setSupervisionUnit(param.getSupervisionUnit());
        addEntity.setSupervisionAreaId(org.getAreaId());
        addEntity.setBusinessStatus(BusinessStatusEnum.NORMAL.getValue());
        addEntity.setIsTest(Integer.valueOf(0));
        addEntity.setEntryTime(LocalDateTime.now());
        this.companyService.save(addEntity);
        if (StrUtil.isNotBlank((CharSequence)param.getManagerName()) && StrUtil.isNotBlank((CharSequence)param.getManagerTel())) {
            CStaffBaseInfoEditParam managerAddParam = new CStaffBaseInfoEditParam();
            CStaffEditParam managerAddSubParam = new CStaffEditParam();
            managerAddParam.setSource(StaffSourceEnum.ADMIN.getValue());
            managerAddParam.setName(param.getManagerName());
            managerAddParam.setPhone(param.getManagerTel());
            managerAddSubParam.setCid(addEntity.getId());
            managerAddParam.setStaffEditParam(managerAddSubParam);
            this.staffEditManager.addManager(managerAddParam);
        }
    }

    private void trim(BCompanyAdminEditParam param) {
        param.setHospitalName(StrUtil.trim((CharSequence)param.getHospitalName()));
        param.setName(StrUtil.trim((CharSequence)param.getName()));
        param.setCreditCode(StrUtil.trim((CharSequence)param.getCreditCode()));
        param.setMedicalNucode(StrUtil.trim((CharSequence)param.getMedicalNucode()));
        param.setAddress(StrUtil.trim((CharSequence)param.getAddress()));
        param.setRegisteredAddress(StrUtil.trim((CharSequence)param.getRegisteredAddress()));
        param.setLegalName(StrUtil.trim((CharSequence)param.getLegalName()));
        param.setLegalTel(StrUtil.trim((CharSequence)param.getLegalTel()));
        param.setMainLeaderName(StrUtil.trim((CharSequence)param.getMainLeaderName()));
        param.setMainLeaderTel(StrUtil.trim((CharSequence)param.getMainLeaderTel()));
    }
}

