/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger.company;

import cn.smarthse.rho.modules.sys.model.r.param.CompanyCertTimeUpdateParam;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCertService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CompanyCertTimeUpdateManager {
    private static final Logger log = LoggerFactory.getLogger(CompanyCertTimeUpdateManager.class);
    private final ICHealthCheckDataService healthCheckDataService;
    private final ICTrainingCertService trainingCertService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final ICDoseDataService doseDataService;
    private final IBCompanyService companyService;
    private final IBCertService cmCertService;
    private final IRiskBasicSourceCommonService riskSourceService;
    private final RedissonClient redissonClient;
    @DubboReference
    private IRiskProvider riskProvider;
    private static final String LOCK_KEY = "CompanyCertTimeUpdateManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateNextVerificationDate(CompanyCertTimeUpdateParam param) {
        log.debug("\u8bb8\u53ef\u8bc1\u65f6\u95f4\u7ef4\u62a4\uff1a\u4e0b\u4e00\u6b21\u6821\u9a8c\u65e5\u671f\u7ef4\u62a4 updateNextVerificationDate() start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_updateNextVerificationDate_").append(param.getLevel3AreaId());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(10L, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.updateNextVerificationDateLock(param);
                log.debug("\u98ce\u9669\u5316\u89e3\uff1a\u8bb8\u53ef\u8bc1\u98ce\u9669 updateNextVerificationDate() end");
                boolean e = true;
                return e;
            }
            catch (Exception e) {
                log.error(e.toString());
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        log.error("{}\uff1aPending lock timeout\uff0cmethod:updateNextVerificationDate()", (Object)LOCK_KEY);
        return false;
    }

    public void updateNextVerificationDateLock(CompanyCertTimeUpdateParam param) {
        this.cmCertService.updateNextVerificationDateLock(param);
    }

    public CompanyCertTimeUpdateManager(ICHealthCheckDataService healthCheckDataService, ICTrainingCertService trainingCertService, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, ICDoseDataService doseDataService, IBCompanyService companyService, IBCertService cmCertService, IRiskBasicSourceCommonService riskSourceService, RedissonClient redissonClient) {
        this.healthCheckDataService = healthCheckDataService;
        this.trainingCertService = trainingCertService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.doseDataService = doseDataService;
        this.companyService = companyService;
        this.cmCertService = cmCertService;
        this.riskSourceService = riskSourceService;
        this.redissonClient = redissonClient;
    }
}

