/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.core.framework.utils.RiskTimeUtil;
import cn.smarthse.rho.modules.sys.entity.b.BCert;
import cn.smarthse.rho.modules.sys.enums.risk.RiskEffectiveEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskSourceEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.r.vo.GenRiskAboutPerformanceVo;
import cn.smarthse.rho.modules.sys.model.r.vo.GenRiskAboutPlaceVo;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskGenVo;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCertService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.service.e.IEDeviceCommonService;
import cn.smarthse.rho.modules.sys.service.e.IEMachineRoomCommonService;
import cn.smarthse.rho.modules.sys.service.sys.ISysAreaService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RiskGenManager {
    private static final Logger log = LoggerFactory.getLogger(RiskGenManager.class);
    private final ICHealthCheckDataService healthCheckDataService;
    private final ICTrainingCertService trainingCertService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final ICDoseDataService doseDataService;
    private final IBCompanyService companyService;
    private final ISysAreaService areaService;
    private final IBCertService cmCertService;
    private final IEDeviceCommonService deviceService;
    private final IEMachineRoomCommonService machineRoomService;
    private final ApplicationContext applicationContext;
    private final RedissonClient redissonClient;
    @DubboReference
    private IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskGenManager";

    public void genPermitCertRiskLock(RiskMangerGenParam param) {
        List<RiskGenVo> list = this.cmCertService.getDataPreRisk(param);
        for (RiskGenVo vo : list) {
            vo.setThirdOrgId(null);
            vo.setSubBusinessId(vo.getCmCertId());
            vo.setType(RiskTypeEnum.LICENSE_MANAGEMENT.getValue());
            BCert cert = this.cmCertService.getByCid(vo.getCid());
            vo.setIsGenerateByData(Integer.valueOf(cert == null ? 0 : 1));
        }
        try {
            this.genRiskForCompanyCert(list);
        }
        catch (Exception e) {
            log.error("\u8bb8\u53ef\u8bc1\u98ce\u9669\u751f\u6210\u5931\u8d25:{}", (Throwable)e);
        }
    }

    public void genRiskForPerson(List<RiskGenVo> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        ArrayList<AddRiskForCommonParam> listParam = new ArrayList<AddRiskForCommonParam>();
        for (RiskGenVo vo : list) {
            List cidList = vo.getCidList();
            if (CollectionUtil.isEmpty((Collection)cidList)) continue;
            for (Long cid : cidList) {
                AddRiskForCommonParam param = new AddRiskForCommonParam();
                param.setCid(cid);
                param.setThirdOrgId(vo.getThirdOrgId());
                param.setBusinessId(vo.getBusinessId());
                param.setSubBusinessId(vo.getSubBusinessId());
                param.setSubBusinessName(vo.getStaffBaseInfoName());
                param.setName(null);
                param.setSource(RiskSourceEnum.PORTRAIT.getValue());
                param.setType(vo.getType());
                param.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
                param.setDescription(null);
                param.setFiles(null);
                param.setStartTime(vo.getStartTime());
                param.setExpireTime(vo.getExpireTime());
                param.setRequireFinishTime(null);
                param.setIsGenerateByData(vo.getIsGenerateByData());
                param.setCid(cid);
                if (param.getSubBusinessId() == null) {
                    throw new ServiceException("\u7f3a\u5c11\u4eba\u5458id");
                }
                listParam.add(param);
            }
        }
        this.riskProvider.genRiskOfCommon(listParam);
    }

    public void genRiskForCompanyCert(List<RiskGenVo> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        ArrayList<AddRiskForCommonParam> listParam = new ArrayList<AddRiskForCommonParam>();
        for (RiskGenVo vo : list) {
            AddRiskForCommonParam param = new AddRiskForCommonParam();
            param.setCid(vo.getCid());
            param.setThirdOrgId(vo.getThirdOrgId());
            param.setBusinessId(vo.getBusinessId());
            param.setSubBusinessId(vo.getSubBusinessId());
            param.setName(null);
            param.setSource(RiskSourceEnum.PORTRAIT.getValue());
            param.setType(vo.getType());
            param.setFinderName("\u5b9a\u65f6\u4efb\u52a1");
            param.setDescription(null);
            param.setFiles(null);
            param.setStartTime(vo.getStartTime());
            param.setExpireTime(vo.getExpireTime());
            param.setRequireFinishTime(null);
            param.setIsGenerateByData(vo.getIsGenerateByData());
            listParam.add(param);
        }
        this.riskProvider.genRiskOfCommon(listParam);
    }

    private LocalDate getReferenceTime(LocalDate startTime, RiskEffectiveEnum effectiveEnum) {
        LocalDate expirationDate = RiskTimeUtil.getExpirationDate((LocalDate)startTime, (Integer)effectiveEnum.getValue(), (Integer)effectiveEnum.getType());
        if (expirationDate == null) {
            throw new ServiceException("\u8fc7\u671f\u65f6\u95f4\u7a7a");
        }
        return expirationDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genPerformanceTestRisk(RiskMangerGenParam param) {
        log.debug("\u98ce\u9669\u7ef4\u62a4\uff1a\u6027\u80fd\u68c0\u6d4b genPerformanceTestRisk() start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_genPerformanceTestRisk_").append(param.getYear());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(10L, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.genPerformanceTestRiskLock(param);
                log.debug("\u98ce\u9669\u7ef4\u62a4\uff1a\u6027\u80fd\u68c0\u6d4b genPerformanceTestRisk() end");
            }
            catch (Exception e) {
                log.error(e.toString());
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:genPerformanceTestRisk()", (Object)LOCK_KEY);
        }
    }

    public void genPerformanceTestRiskLock(RiskMangerGenParam param) {
        List<GenRiskAboutPerformanceVo> deviceList = this.deviceService.searchDeviceForPerformanceRiskTask();
        if (!CollectionUtils.isEmpty(deviceList)) {
            ArrayList<AddRiskForCommonParam> genRiskParamList = new ArrayList<AddRiskForCommonParam>();
            for (GenRiskAboutPerformanceVo device : deviceList) {
                AddRiskForCommonParam genRiskParam = new AddRiskForCommonParam();
                genRiskParam.setCid(device.getCid());
                genRiskParam.setBusinessId(device.getBusinessId());
                genRiskParam.setSubBusinessId(device.getSubBusinessId());
                genRiskParam.setSubBusinessName(device.getName());
                genRiskParam.setName(null);
                genRiskParam.setType(RiskTypeEnum.PERFORMANCE_TEST.getValue());
                genRiskParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
                genRiskParam.setFinderName("\u7cfb\u7edf\u53d1\u73b0");
                genRiskParam.setDescription("");
                genRiskParam.setFiles(null);
                genRiskParam.setStartTime(device.getCheckTime() == null ? LocalDate.now() : device.getCheckTime());
                genRiskParam.setIsGenerateByData(Integer.valueOf(device.getCheckTime() == null ? 0 : 1));
                genRiskParamList.add(genRiskParam);
            }
            try {
                this.riskProvider.genRiskOfCommon(genRiskParamList);
            }
            catch (Exception e) {
                log.error("\u6027\u80fd\u68c0\u6d4b\u751f\u6210\u5931\u8d25");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genPlaceTestRisk(RiskMangerGenParam param) {
        log.debug("\u98ce\u9669\u7ef4\u62a4\uff1a\u573a\u6240\u68c0\u6d4b genPlaceTestRisk() start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_genPlaceTestRisk_").append(param.getYear());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(10L, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.genPlaceTestRiskLock(param);
                log.debug("\u98ce\u9669\u7ef4\u62a4\uff1a\u573a\u6240\u68c0\u6d4b genPlaceTestRisk() end");
            }
            catch (Exception e) {
                log.error(e.toString());
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:genPlaceTestRisk()", (Object)LOCK_KEY);
        }
    }

    public void genPlaceTestRiskLock(RiskMangerGenParam param) {
        List<GenRiskAboutPlaceVo> roomList = this.machineRoomService.searchRoomForPlaceRiskTask();
        if (!CollectionUtils.isEmpty(roomList)) {
            ArrayList<AddRiskForCommonParam> genRiskParamList = new ArrayList<AddRiskForCommonParam>();
            for (GenRiskAboutPlaceVo room : roomList) {
                AddRiskForCommonParam genRiskParam = new AddRiskForCommonParam();
                genRiskParam.setCid(room.getCid());
                genRiskParam.setBusinessId(room.getBusinessId());
                genRiskParam.setSubBusinessId(room.getSubBusinessId());
                genRiskParam.setSubBusinessName(room.getName());
                genRiskParam.setName(null);
                genRiskParam.setType(RiskTypeEnum.PLACE_TEST.getValue());
                genRiskParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
                genRiskParam.setFinderName("\u7cfb\u7edf\u53d1\u73b0");
                genRiskParam.setDescription("");
                genRiskParam.setFiles(null);
                genRiskParam.setStartTime(room.getCheckTime() == null ? LocalDate.now() : room.getCheckTime());
                genRiskParam.setIsGenerateByData(Integer.valueOf(room.getCheckTime() == null ? 0 : 1));
                genRiskParamList.add(genRiskParam);
            }
            try {
                this.riskProvider.genRiskOfCommon(genRiskParamList);
            }
            catch (Exception e) {
                log.error("\u573a\u6240\u68c0\u6d4b\u751f\u6210\u5931\u8d25");
            }
        }
    }

    public RiskGenManager(ICHealthCheckDataService healthCheckDataService, ICTrainingCertService trainingCertService, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, ICDoseDataService doseDataService, IBCompanyService companyService, ISysAreaService areaService, IBCertService cmCertService, IEDeviceCommonService deviceService, IEMachineRoomCommonService machineRoomService, ApplicationContext applicationContext, RedissonClient redissonClient) {
        this.healthCheckDataService = healthCheckDataService;
        this.trainingCertService = trainingCertService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.doseDataService = doseDataService;
        this.companyService = companyService;
        this.areaService = areaService;
        this.cmCertService = cmCertService;
        this.deviceService = deviceService;
        this.machineRoomService = machineRoomService;
        this.applicationContext = applicationContext;
        this.redissonClient = redissonClient;
    }
}

