/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.manger;

import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCertService;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.service.e.IEDeviceCommonService;
import cn.smarthse.rho.modules.sys.service.e.IEMachineRoomCommonService;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RiskAboutStatusManager {
    private static final Logger log = LoggerFactory.getLogger(RiskAboutStatusManager.class);
    private final ICHealthCheckDataService healthCheckDataService;
    private final ICTrainingCertService trainingCertService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final ICDoseDataService doseDataService;
    private final IBCompanyService companyService;
    private final IBCertService cmCertService;
    private final IEDeviceCommonService deviceService;
    private final IEMachineRoomCommonService machineRoomService;
    private final RedissonClient redissonClient;
    @DubboReference
    private IRiskProvider riskProvider;
    private static final String LOCK_KEY = "RiskAboutStatusManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSourceRiskWarningStatus(RiskMangerGenParam param) {
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_sourceRiskWarningStatus_").append(param.getYear());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(10L, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.riskProvider.searchAndChangeSourceRiskWarningStatus(param);
            }
            catch (Exception e) {
                log.error("\u98ce\u9669\u9884\u8b66\u72b6\u6001\u7ef4\u62a4\u5931\u8d25");
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:changeSourceRiskWarningStatus()", (Object)LOCK_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeBasicRiskWarningStatus(RiskMangerGenParam param) {
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_basicRiskWarningStatus_").append(param.getYear());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(10L, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.riskProvider.searchAndChangeBasicRiskWarningStatus(param);
            }
            catch (Exception e) {
                log.error("\u98ce\u9669\u9884\u8b66\u72b6\u6001\u7ef4\u62a4\u5931\u8d25");
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:changeBasicRiskWarningStatus()", (Object)LOCK_KEY);
        }
    }

    public RiskAboutStatusManager(ICHealthCheckDataService healthCheckDataService, ICTrainingCertService trainingCertService, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, ICDoseDataService doseDataService, IBCompanyService companyService, IBCertService cmCertService, IEDeviceCommonService deviceService, IEMachineRoomCommonService machineRoomService, RedissonClient redissonClient) {
        this.healthCheckDataService = healthCheckDataService;
        this.trainingCertService = trainingCertService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.doseDataService = doseDataService;
        this.companyService = companyService;
        this.cmCertService = cmCertService;
        this.deviceService = deviceService;
        this.machineRoomService = machineRoomService;
        this.redissonClient = redissonClient;
    }
}

