/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.bootstrap;

import cn.smarthse.core.framework.bean.OssClientBean;
import cn.smarthse.core.framework.bootstrap.BaseConfiguration;
import cn.smarthse.core.framework.bootstrap.properties.MasSmsProperties;
import cn.smarthse.core.framework.bootstrap.properties.OssClientProperties;
import cn.smarthse.core.framework.bootstrap.properties.SmtProperties;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.utils.SpringContextHolder;
import cn.smarthse.rho.modules.sys.bootstrap.properties.EmailProperties;
import java.util.Properties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableAsync
@EnableScheduling
@EnableConfigurationProperties(value={MasSmsProperties.class, SmtProperties.class, OssClientProperties.class, EmailProperties.class, SysProperties.class})
@ComponentScan(value={"cn.smarthse.common.json", "cn.smarthse.common.redis", "cn.smarthse.common.web"})
public class ContentConfiguration
extends BaseConfiguration {
    private final OssClientProperties ossClientProperties;
    private final EmailProperties emailProperties;

    @Bean(name={"ossclient"})
    public OssClientBean getOssClientBean() {
        this.logger.info("\u914d\u7f6e OssClientBean {}", (Object)this.ossClientProperties.getOss_bucketname());
        OssClientBean ossClientBean = new OssClientBean();
        ossClientBean.setLocal(this.ossClientProperties.getOss_local());
        ossClientBean.setDomain(this.ossClientProperties.getDomain());
        ossClientBean.setEndpoint(this.ossClientProperties.getOss_endpoint());
        ossClientBean.setAccessKeyId(this.ossClientProperties.getOss_accesskey());
        ossClientBean.setAccessKeySecret(this.ossClientProperties.getOss_accesssecret());
        ossClientBean.setBucketName(this.ossClientProperties.getOss_bucketname());
        ossClientBean.setAsynch(this.ossClientProperties.isOss_asynch());
        ossClientBean.setPublicread(this.ossClientProperties.isPublicread());
        ossClientBean.setExptime(this.ossClientProperties.getExptime());
        return ossClientBean;
    }

    @Bean(value={"emailTemplate"})
    public JavaMailSenderImpl getJavaMailSenderImpl() {
        this.logger.info("\u914d\u7f6e JavaMailSenderImpl {}", (Object)this.emailProperties);
        JavaMailSenderImpl emailTemplate = new JavaMailSenderImpl();
        emailTemplate.setDefaultEncoding(this.emailProperties.getDefault_encoding());
        emailTemplate.setHost(this.emailProperties.getHost());
        emailTemplate.setPort(this.emailProperties.getPort());
        emailTemplate.setUsername(this.emailProperties.getUsername().trim().split(",")[0]);
        emailTemplate.setPassword(this.emailProperties.getPassword().trim().split(",")[0]);
        Properties javaMailProperties = new Properties();
        javaMailProperties.setProperty("mail.smtp.auth", "true");
        javaMailProperties.setProperty("mail.smtp.timeout", "25000");
        javaMailProperties.put("mail.smtp.starttls.enable", (Object)true);
        javaMailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        emailTemplate.setJavaMailProperties(javaMailProperties);
        return emailTemplate;
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    @Bean
    RestTemplate restTemplate() {
        return new RestTemplate();
    }

    public ContentConfiguration(OssClientProperties ossClientProperties, EmailProperties emailProperties) {
        this.ossClientProperties = ossClientProperties;
        this.emailProperties = emailProperties;
    }
}

