/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.utils.risk;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.smarthse.rho.modules.sys.enums.RhoTimeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarningTypeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WarningTypeUtil.class);

    public static Integer calculateNonDataWarningType(LocalDateTime time) {
        if (time == null) {
            throw new ServiceException("\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LocalDateTime now = LocalDateTime.now();
        Duration diffTime = LocalDateTimeUtil.between((LocalDateTime)now, (LocalDateTime)time);
        long diffSeconds = diffTime.getSeconds();
        long abs = Math.abs(diffSeconds);
        int warnType = RiskWarningStatusEnum.NONE.getValue();
        warnType = diffSeconds > 0L ? RiskWarningStatusEnum.NONE.getValue() : (abs < RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.RED.getValue().intValue() : RiskWarningStatusEnum.ACTIVATE_LAW.getValue().intValue());
        return warnType;
    }

    public static Integer calculateHasDataWarningType(LocalDateTime now, LocalDateTime expireDate) {
        Duration diffTime = LocalDateTimeUtil.between((LocalDateTime)now, (LocalDateTime)expireDate);
        return WarningTypeUtil.calculateHasDataWarningType(diffTime.getSeconds());
    }

    private static Integer calculateHasDataWarningType(long diffTimes) {
        Integer warnType = RiskWarningStatusEnum.NONE.getValue();
        long abs = Math.abs(diffTimes);
        warnType = diffTimes > 0L ? (RhoTimeEnum.SECOND_OF_90_DAY.getTime() < abs ? RiskWarningStatusEnum.NONE.getValue() : (RhoTimeEnum.SECOND_OF_30_DAY.getTime() < abs && abs <= RhoTimeEnum.SECOND_OF_90_DAY.getTime() ? RiskWarningStatusEnum.FIRST.getValue() : (abs <= RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.YELLOW.getValue() : RiskWarningStatusEnum.NONE.getValue()))) : (abs < RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.RED.getValue() : RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        return warnType;
    }

    public static Integer calculateHasDataWarningTypeForCompanyCert(LocalDateTime now, LocalDateTime expireDate, Integer cycleYear) {
        if (cycleYear == null) {
            return null;
        }
        Duration diffTime = LocalDateTimeUtil.between((LocalDateTime)now, (LocalDateTime)expireDate);
        long diffTimes = diffTime.getSeconds();
        if (cycleYear == 1 && diffTimes <= -RhoTimeEnum.SECOND_OF_30_DAY.getTime().longValue()) {
            return RiskWarningStatusEnum.NONE.getValue();
        }
        return WarningTypeUtil.calculateHasDataWarningType(diffTimes);
    }

    public static Integer calculateHasDataWarningTypeForDose(LocalDateTime now, LocalDateTime expireDate) {
        Duration diffTime = LocalDateTimeUtil.between((LocalDateTime)now, (LocalDateTime)expireDate);
        long diffTimes = diffTime.getSeconds();
        long abs = Math.abs(diffTimes);
        Integer warnType = RiskWarningStatusEnum.NONE.getValue();
        warnType = diffTimes > 0L ? (abs <= RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.YELLOW.getValue() : RiskWarningStatusEnum.NONE.getValue()) : (abs <= RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.RED.getValue() : RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        return warnType;
    }
}

