/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.utils.company;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.smarthse.rho.modules.sys.enums.RhoTimeEnum;
import cn.smarthse.rho.modules.sys.enums.company.CompanyCertCycleEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public class CompanyCertUtil {
    public static LocalDateTime calculateExpireDate(LocalDateTime beginDate, LocalDateTime lastVerificationDate, Integer cycleYear, int pushType) {
        LocalDateTime startTime;
        lastVerificationDate = lastVerificationDate == null ? beginDate : lastVerificationDate;
        LocalDateTime localDateTime = startTime = pushType == 1 ? beginDate : lastVerificationDate;
        if (startTime == null) {
            return null;
        }
        if (pushType == 2) {
            return LocalDateTimeUtil.offset((LocalDateTime)startTime, (long)cycleYear.intValue(), (TemporalUnit)ChronoUnit.YEARS);
        }
        LocalDateTime endTime = lastVerificationDate;
        int diffYear = endTime.getYear() - startTime.getYear();
        if (diffYear < 0) {
            return startTime;
        }
        long periodsElapsed = ChronoUnit.YEARS.between(startTime, endTime) / (long)cycleYear.intValue();
        LocalDateTime currentPeriodStart = startTime.plusYears(periodsElapsed * (long)cycleYear.intValue());
        LocalDateTime currentPeriodEnd = currentPeriodStart.plusYears(cycleYear.intValue());
        return currentPeriodEnd;
    }

    public static LocalDateTime calculateStartDate(Integer cycleYear, LocalDateTime expireTime) {
        LocalDateTime startTime = LocalDateTimeUtil.offset((LocalDateTime)expireTime, (long)(-cycleYear.intValue()), (TemporalUnit)ChronoUnit.YEARS);
        return startTime;
    }

    public static Integer calculateCycleYear(Integer companyType, Integer floorNum) {
        return CompanyCertCycleEnum.getCycle(String.valueOf(companyType), floorNum);
    }

    public static Integer calculateHasDataWarningTypeForCompanyCert(LocalDateTime now, LocalDateTime expireDate, Integer cycleYear) {
        Duration diffTime = LocalDateTimeUtil.between((LocalDateTime)now, (LocalDateTime)expireDate);
        long diffTimes = diffTime.getSeconds();
        if (cycleYear == 1 && diffTimes <= -RhoTimeEnum.SECOND_OF_30_DAY.getTime().longValue()) {
            return RiskWarningStatusEnum.NONE.getValue();
        }
        return CompanyCertUtil.calculateHasDataWarningType(diffTimes);
    }

    public static Integer calculateHasDataWarningType(long diffTimes) {
        Integer warnType = RiskWarningStatusEnum.NONE.getValue();
        long abs = Math.abs(diffTimes);
        warnType = diffTimes > 0L ? (RhoTimeEnum.SECOND_OF_90_DAY.getTime() < abs ? RiskWarningStatusEnum.NONE.getValue() : (RhoTimeEnum.SECOND_OF_30_DAY.getTime() < abs && abs <= RhoTimeEnum.SECOND_OF_90_DAY.getTime() ? RiskWarningStatusEnum.FIRST.getValue() : (abs <= RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.YELLOW.getValue() : RiskWarningStatusEnum.NONE.getValue()))) : (abs < RhoTimeEnum.SECOND_OF_30_DAY.getTime() ? RiskWarningStatusEnum.RED.getValue() : RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        return warnType;
    }
}

