/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.enums.staff.IdCardTypeEnum;
import java.time.LocalDate;
import java.time.Period;
import java.util.Date;

public class RhoIdCardUtil {
    private static final String HK_MC_HOME_RETURN_PERMIT_REGEX = "^[HM]\\d{8}$";
    private static final String TW_HOME_RETURN_PERMIT_REGEX = "^\\d{8}$";

    public static boolean isValidIdCard_15_18(String idCard) {
        return IdcardUtil.isValidCard18((String)idCard) || IdcardUtil.isValidCard15((String)idCard);
    }

    public static boolean isValid_CN_DL_IdCard18(String idCard) {
        if (StrUtil.isBlank((CharSequence)idCard)) {
            return false;
        }
        String idCardType = RhoIdCardUtil.getIdCardType(idCard);
        return IdcardUtil.isValidCard18((String)idCard) && IdCardTypeEnum.ID_CARD.getValue().equals(idCardType);
    }

    public static boolean isValid_CN_HkMcTw_IdCard(String idCard) {
        if (StrUtil.isBlank((CharSequence)idCard)) {
            return false;
        }
        String idCardType = RhoIdCardUtil.getIdCardType(idCard);
        return IdCardTypeEnum.ID_CARD_HK_MC_TW.getValue().equals(idCardType);
    }

    public static boolean isValid_CN_Wxk_IdCard(String idCard) {
        if (StrUtil.isBlank((CharSequence)idCard)) {
            return false;
        }
        String idCardType = RhoIdCardUtil.getIdCardType(idCard);
        return IdCardTypeEnum.ID_CARD_WXK.getValue().equals(idCardType);
    }

    public static boolean isValid_HkMc_RoundTripPermit(String idCard) {
        if (StrUtil.isBlank((CharSequence)idCard)) {
            return false;
        }
        return ReUtil.isMatch((String)HK_MC_HOME_RETURN_PERMIT_REGEX, (CharSequence)idCard);
    }

    public static boolean isValid_Tw_RoundTripPermit(String idCard) {
        if (StrUtil.isBlank((CharSequence)idCard)) {
            return false;
        }
        return ReUtil.isMatch((String)TW_HOME_RETURN_PERMIT_REGEX, (CharSequence)idCard);
    }

    public static String getIdCardType(String idCard) {
        if (StrUtil.isBlank((CharSequence)idCard)) {
            return null;
        }
        if (IdcardUtil.isValidCard18((String)idCard)) {
            if (idCard.startsWith("81") || idCard.startsWith("82") || idCard.startsWith("83")) {
                return IdCardTypeEnum.ID_CARD_HK_MC_TW.getValue();
            }
            if (idCard.startsWith("9")) {
                return IdCardTypeEnum.ID_CARD_WXK.getValue();
            }
            return IdCardTypeEnum.ID_CARD.getValue();
        }
        if (IdcardUtil.isValidCard15((String)idCard)) {
            return IdCardTypeEnum.ID_CARD_HK_MC_TW.getValue();
        }
        if (RhoIdCardUtil.isValid_HkMc_RoundTripPermit(idCard)) {
            return IdCardTypeEnum.HK_MC_HOME_RETURN_PERMIT.getValue();
        }
        if (RhoIdCardUtil.isValid_Tw_RoundTripPermit(idCard)) {
            return IdCardTypeEnum.TW_HOME_RETURN_PERMIT.getValue();
        }
        return null;
    }

    public static Integer getSex(String idCard, Integer ifNullResult) {
        return RhoIdCardUtil.isValidIdCard_15_18(idCard) ? Integer.valueOf(IdcardUtil.getGenderByIdCard((String)idCard)) : ifNullResult;
    }

    public static Integer getAge(String idCard, Integer ifNullResult) {
        return RhoIdCardUtil.isValidIdCard_15_18(idCard) ? Integer.valueOf(IdcardUtil.getAgeByIdCard((String)idCard)) : ifNullResult;
    }

    public static Integer getAge(LocalDate birthDate) {
        return Period.between(birthDate, LocalDate.now()).getYears();
    }

    public static Integer getAge(String idCard, LocalDate birthDate, Integer ifNullResult) {
        if (RhoIdCardUtil.isValidIdCard_15_18(idCard)) {
            return IdcardUtil.getAgeByIdCard((String)idCard);
        }
        if (birthDate != null) {
            return RhoIdCardUtil.getAge(birthDate);
        }
        return ifNullResult;
    }

    public static LocalDate getBirth(String idCard, LocalDate ifNullResult) {
        return RhoIdCardUtil.isValidIdCard_15_18(idCard) ? LocalDate.from(DateUtil.toLocalDateTime((Date)IdcardUtil.getBirthDate((String)idCard))) : ifNullResult;
    }
}

