/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.utils;

import cn.hutool.core.util.StrUtil;
import java.util.HashMap;

public class NeutronNameUtil {
    public static String originalName2MontageName(String original) {
        int splitIndex;
        HashMap<Character, Character> superscriptMap = new HashMap<Character, Character>();
        superscriptMap.put(Character.valueOf('\u2070'), Character.valueOf('0'));
        superscriptMap.put(Character.valueOf('\u00b9'), Character.valueOf('1'));
        superscriptMap.put(Character.valueOf('\u00b2'), Character.valueOf('2'));
        superscriptMap.put(Character.valueOf('\u00b3'), Character.valueOf('3'));
        superscriptMap.put(Character.valueOf('\u2074'), Character.valueOf('4'));
        superscriptMap.put(Character.valueOf('\u2075'), Character.valueOf('5'));
        superscriptMap.put(Character.valueOf('\u2076'), Character.valueOf('6'));
        superscriptMap.put(Character.valueOf('\u2077'), Character.valueOf('7'));
        superscriptMap.put(Character.valueOf('\u2078'), Character.valueOf('8'));
        superscriptMap.put(Character.valueOf('\u2079'), Character.valueOf('9'));
        for (splitIndex = 0; splitIndex < original.length() && superscriptMap.containsKey(Character.valueOf(original.charAt(splitIndex))); ++splitIndex) {
        }
        String neutronPart = original.substring(0, splitIndex);
        String elementPart = original.substring(splitIndex);
        StringBuilder convertedNeutron = new StringBuilder();
        for (char c : neutronPart.toCharArray()) {
            convertedNeutron.append(superscriptMap.get(Character.valueOf(c)));
        }
        return convertedNeutron.toString() + "-" + elementPart;
    }

    public static String montageName2OriginalName(String original) {
        HashMap<Character, Character> subscriptMap = new HashMap<Character, Character>();
        subscriptMap.put(Character.valueOf('0'), Character.valueOf('\u2070'));
        subscriptMap.put(Character.valueOf('1'), Character.valueOf('\u00b9'));
        subscriptMap.put(Character.valueOf('2'), Character.valueOf('\u00b2'));
        subscriptMap.put(Character.valueOf('3'), Character.valueOf('\u00b3'));
        subscriptMap.put(Character.valueOf('4'), Character.valueOf('\u2074'));
        subscriptMap.put(Character.valueOf('5'), Character.valueOf('\u2075'));
        subscriptMap.put(Character.valueOf('6'), Character.valueOf('\u2076'));
        subscriptMap.put(Character.valueOf('7'), Character.valueOf('\u2077'));
        subscriptMap.put(Character.valueOf('8'), Character.valueOf('\u2078'));
        subscriptMap.put(Character.valueOf('9'), Character.valueOf('\u2079'));
        String[] parts = original.split("-", 2);
        if (parts.length != 2) {
            return original;
        }
        String numberPart = parts[0];
        String elementPart = parts[1];
        StringBuilder convertedNumber = new StringBuilder();
        for (char c : numberPart.toCharArray()) {
            Character supChar = (Character)subscriptMap.get(Character.valueOf(c));
            if (supChar != null) {
                convertedNumber.append(supChar);
                continue;
            }
            convertedNumber.append(c);
        }
        return convertedNumber.toString() + elementPart;
    }

    public static boolean isValidMontageName(String input) {
        if (input.chars().filter(c -> c == 45).count() != 1L) {
            return false;
        }
        String[] parts = input.split("-", 2);
        if (parts[0].isEmpty()) {
            return false;
        }
        if (parts[1].isEmpty()) {
            return false;
        }
        if (!parts[0].matches("\\d+")) {
            return false;
        }
        return parts[1].matches("[A-Za-z]+");
    }

    public static String formatName(String symbol, String neutrons, String energyState) {
        HashMap<Character, Character> superscriptMap = new HashMap<Character, Character>();
        superscriptMap.put(Character.valueOf('0'), Character.valueOf('\u2070'));
        superscriptMap.put(Character.valueOf('1'), Character.valueOf('\u00b9'));
        superscriptMap.put(Character.valueOf('2'), Character.valueOf('\u00b2'));
        superscriptMap.put(Character.valueOf('3'), Character.valueOf('\u00b3'));
        superscriptMap.put(Character.valueOf('4'), Character.valueOf('\u2074'));
        superscriptMap.put(Character.valueOf('5'), Character.valueOf('\u2075'));
        superscriptMap.put(Character.valueOf('6'), Character.valueOf('\u2076'));
        superscriptMap.put(Character.valueOf('7'), Character.valueOf('\u2077'));
        superscriptMap.put(Character.valueOf('8'), Character.valueOf('\u2078'));
        superscriptMap.put(Character.valueOf('9'), Character.valueOf('\u2079'));
        superscriptMap.put(Character.valueOf('m'), Character.valueOf('\u1d50'));
        StringBuilder convertedNeutrons = new StringBuilder();
        for (char c : neutrons.toCharArray()) {
            Character supChar = (Character)superscriptMap.get(Character.valueOf(c));
            if (supChar != null) {
                convertedNeutrons.append(supChar);
                continue;
            }
            convertedNeutrons.append(c);
        }
        if (!StrUtil.isBlank((CharSequence)energyState)) {
            energyState = "(" + (String)energyState + ")";
        }
        return String.valueOf(convertedNeutrons) + symbol + (String)energyState;
    }
}

