/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.enums.health;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Generated;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum HealthCheckResultEnum {
    ZC("\u6b63\u5e38", "1"),
    FC("\u590d\u67e5", "2"),
    YSZYB("\u7591\u4f3c\u804c\u4e1a\u75c5", "3"),
    ZYJJZ("\u804c\u4e1a\u7981\u5fcc\u8bc1", "4"),
    QT("\u5176\u4ed6\u75be\u75c5\u6216\u5f02\u5e38", "5");

    private String name;
    private String value;

    public static String getName(String value) {
        for (HealthCheckResultEnum c : HealthCheckResultEnum.values()) {
            if (!c.getValue().equals(value)) continue;
            return c.getName();
        }
        return "";
    }

    public static boolean containValue(String value) {
        for (HealthCheckResultEnum c : HealthCheckResultEnum.values()) {
            if (!c.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isError(String resultCode) {
        if (StrUtil.isBlank((CharSequence)resultCode)) {
            return false;
        }
        return !resultCode.equals("1") && !resultCode.equals("5");
    }

    public static Integer getRiskTypeCode(String resultCode) {
        HealthCheckResultEnum temp = null;
        for (HealthCheckResultEnum c : HealthCheckResultEnum.values()) {
            if (!c.getValue().equals(resultCode)) continue;
            temp = c;
        }
        if (temp == null) {
            return null;
        }
        if (temp.getValue().equals(ZC.getValue())) {
            return RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
        }
        if (temp.getValue().equals(YSZYB.getValue())) {
            return RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue();
        }
        if (temp.getValue().equals(ZYJJZ.getValue())) {
            return RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue();
        }
        if (temp.getValue().equals(FC.getValue())) {
            return RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue();
        }
        if (temp.getValue().equals(QT.getValue())) {
            return RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
        }
        return null;
    }

    @Generated
    private HealthCheckResultEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getValue() {
        return this.value;
    }
}

