/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.enums.company;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum EdeviceDiagnosisTypeEnum {
    XRAY(10, "X\u5c04\u7ebf\u5f71\u50cf\u8bca\u65ad"),
    XRAY_CT(11, "X\u5c04\u7ebfCT\u5f71\u50cf\u8bca\u65ad"),
    XRAY_CRDR(12, "CR\u3001DR\u5f71\u50cf\u8bca\u65ad"),
    XRAY_DENTISTRY(13, "\u7259\u79d1X\u5c04\u7ebf\u5f71\u50cf\u8bca\u65ad"),
    XRAY_BREAST(14, "\u4e73\u817aX\u5c04\u7ebf\u5f71\u50cf\u8bca\u65ad"),
    XRAY_ORDINARY(15, "\u666e\u901aX\u5c04\u7ebf\u673a\u5f71\u50cf\u8bca\u65ad"),
    XRAY_OTHER(16, "\u5176\u4ed6X\u5c04\u7ebf\u5f71\u50cf\u8bca\u65ad"),
    INTERVENTIONAL(20, "\u4ecb\u5165\u653e\u5c04\u5b66"),
    INTERVENTIONAL_DSA(21, "DSA\u4ecb\u5165\u653e\u5c04\u8bca\u7597"),
    INTERVENTIONAL_OTHER(22, "\u5176\u4ed6\u5f71\u50cf\u8bbe\u5907\u4ecb\u5165\u653e\u5c04\u8bca\u7597"),
    NUCLEAR(30, "\u6838\u533b\u5b66"),
    NUCLEAR_PET(31, "PET\u5f71\u50cf\u8bca\u65ad"),
    NUCLEAR_SPECT(32, "SPECT\u5f71\u50cf\u8bca\u65ad"),
    NUCLEAR_Y(33, "\u03b3\u76f8\u673a\u5f71\u50cf\u8bca\u65ad"),
    NUCLEAR_BONE(34, "\u9aa8\u5bc6\u5ea6\u6d4b\u91cf\uff08\u03b3\u5c04\u7ebf\uff09"),
    NUCLEAR_SEED(35, "\u7c7d\u7c92\u63d2\u690d\u6cbb\u7597"),
    NUCLEAR_RADIOPHARMACEUTICAL(36, "\u653e\u5c04\u6027\u836f\u7269\u6cbb\u7597"),
    NUCLEAR_OTHER(37, "\u5176\u4ed6\u6838\u533b\u5b66\u8bca\u7597\u9879\u76ee"),
    RADIATION_THERAPY(40, "\u653e\u5c04\u6cbb\u7597"),
    RADIATION_THERAPY_YX(41, "\u7acb\u4f53\u5b9a\u5411\uff08\u03b3\u5200\u3001X\u5200\uff09\u6cbb\u7597"),
    RADIATION_THERAPY_MEDICAL(42, "\u533b\u7528\u52a0\u901f\u5668\u6cbb\u7597"),
    RADIATION_THERAPY_PROTON(43, "\u8d28\u5b50\u7b49\u91cd\u7c92\u5b50\u6cbb\u7597"),
    RADIATION_THERAPY_COBALT(44, "\u653e\u5c04\u6cbb\u7597-\u94b4-60\u673a\u6cbb\u7597"),
    RADIATION_THERAPY_AFTERLOADING(45, "\u540e\u88c5\u6cbb\u7597"),
    RADIATION_THERAPY_DEEPX(46, "\u6df1\u90e8X\u5c04\u7ebf\u673a\u6cbb\u7597"),
    RADIATION_THERAPY_APPLICATION(47, "\u6577\u8d34\u6cbb\u7597"),
    RADIATION_THERAPY_OTHER(48, "\u5176\u4ed6\u653e\u5c04\u6cbb\u7597\u9879\u76ee");

    private Integer value;
    private String name;

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (EdeviceDiagnosisTypeEnum c : EdeviceDiagnosisTypeEnum.values()) {
            if (!c.getValue().equals(value)) continue;
            return c.name;
        }
        return null;
    }

    public static Integer getCodeByName(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return null;
        }
        for (EdeviceDiagnosisTypeEnum c : EdeviceDiagnosisTypeEnum.values()) {
            if (!c.getName().equals(name)) continue;
            return c.value;
        }
        return null;
    }

    public static String getCodesByNames(String names, String split) {
        List<String> nameList;
        if (cn.smarthse.rho.core.framework.utils.StringUtils.isNotEmpty((String)names) && !CollectionUtils.isEmpty(nameList = Pattern.compile(",").splitAsStream(names).collect(Collectors.toList()))) {
            ArrayList resultList = new ArrayList();
            nameList.forEach(name -> {
                Integer result = EdeviceDiagnosisTypeEnum.getCodeByName(name);
                if (result != null) {
                    resultList.add(String.valueOf(result));
                }
            });
            return CollUtil.isEmpty(resultList) ? null : StringUtils.join(resultList, (String)split);
        }
        return null;
    }

    public static String getNamesByCodes(String codes) {
        List<Integer> codeList;
        if (cn.smarthse.rho.core.framework.utils.StringUtils.isNotEmpty((String)codes) && !CollectionUtils.isEmpty(codeList = Pattern.compile(",").splitAsStream(codes).filter(v -> StrUtil.isNumeric((CharSequence)v)).map(v -> Integer.valueOf(v)).collect(Collectors.toList()))) {
            ArrayList nameList = new ArrayList();
            codeList.forEach(value -> nameList.add(EdeviceDiagnosisTypeEnum.getName(value)));
            return StringUtils.join(nameList, (String)"\u3001");
        }
        return "";
    }

    public static String getNamesByCodes(String codes, String split) {
        List<Integer> codeList;
        if (cn.smarthse.rho.core.framework.utils.StringUtils.isNotEmpty((String)codes) && !CollectionUtils.isEmpty(codeList = Pattern.compile(",").splitAsStream(codes).filter(v -> StrUtil.isNumeric((CharSequence)v)).map(v -> Integer.valueOf(v)).collect(Collectors.toList()))) {
            ArrayList nameList = new ArrayList();
            codeList.forEach(value -> nameList.add(EdeviceDiagnosisTypeEnum.getName(value)));
            return StringUtils.join(nameList, (String)split);
        }
        return "";
    }

    public static String getXrayNamesByCodes(String codes, String split) {
        List<Integer> codeList;
        if (cn.smarthse.rho.core.framework.utils.StringUtils.isNotEmpty((String)codes) && !CollectionUtils.isEmpty(codeList = Pattern.compile(",").splitAsStream(codes).filter(v -> StrUtil.isNumeric((CharSequence)v)).map(v -> Integer.valueOf(v)).filter(v -> EdeviceDiagnosisTypeEnum.isXRAY(v)).collect(Collectors.toList()))) {
            ArrayList nameList = new ArrayList();
            codeList.forEach(value -> nameList.add(EdeviceDiagnosisTypeEnum.getName(value)));
            return StringUtils.join(nameList, (String)split);
        }
        return "";
    }

    public static String getInterventionalNamesByCodes(String codes, String split) {
        List<Integer> codeList;
        if (cn.smarthse.rho.core.framework.utils.StringUtils.isNotEmpty((String)codes) && !CollectionUtils.isEmpty(codeList = Pattern.compile(",").splitAsStream(codes).filter(v -> StrUtil.isNumeric((CharSequence)v)).map(v -> Integer.valueOf(v)).filter(v -> EdeviceDiagnosisTypeEnum.isINTERVENTIONAL(v)).collect(Collectors.toList()))) {
            ArrayList nameList = new ArrayList();
            codeList.forEach(value -> nameList.add(EdeviceDiagnosisTypeEnum.getName(value)));
            return StringUtils.join(nameList, (String)split);
        }
        return "";
    }

    public static String getNuclearNamesByCodes(String codes, String split) {
        List<Integer> codeList;
        if (cn.smarthse.rho.core.framework.utils.StringUtils.isNotEmpty((String)codes) && !CollectionUtils.isEmpty(codeList = Pattern.compile(",").splitAsStream(codes).filter(v -> StrUtil.isNumeric((CharSequence)v)).map(v -> Integer.valueOf(v)).filter(v -> EdeviceDiagnosisTypeEnum.isNUCLEAR(v)).collect(Collectors.toList()))) {
            ArrayList nameList = new ArrayList();
            codeList.forEach(value -> nameList.add(EdeviceDiagnosisTypeEnum.getName(value)));
            return StringUtils.join(nameList, (String)split);
        }
        return "";
    }

    public static String getRadiationNamesByCodes(String codes, String split) {
        List<Integer> codeList;
        if (cn.smarthse.rho.core.framework.utils.StringUtils.isNotEmpty((String)codes) && !CollectionUtils.isEmpty(codeList = Pattern.compile(",").splitAsStream(codes).filter(v -> StrUtil.isNumeric((CharSequence)v)).map(v -> Integer.valueOf(v)).filter(v -> EdeviceDiagnosisTypeEnum.isRADIATION_THERAPY(v)).collect(Collectors.toList()))) {
            ArrayList nameList = new ArrayList();
            codeList.forEach(value -> nameList.add(EdeviceDiagnosisTypeEnum.getName(value)));
            return StringUtils.join(nameList, (String)split);
        }
        return "";
    }

    public static boolean isXRAY(Integer value) {
        return value >= 10 && value < 20;
    }

    public static boolean isINTERVENTIONAL(Integer value) {
        return value >= 20 && value < 30;
    }

    public static boolean isNUCLEAR(Integer value) {
        return value >= 30 && value < 40;
    }

    public static boolean isRADIATION_THERAPY(Integer value) {
        return value >= 40 && value < 50;
    }

    public static boolean isXRAYForError(Integer value) {
        return Objects.equals(value, EdeviceDiagnosisTypeEnum.XRAY_CT.value) || Objects.equals(value, EdeviceDiagnosisTypeEnum.XRAY_CRDR.value) || Objects.equals(value, EdeviceDiagnosisTypeEnum.XRAY_DENTISTRY.value) || Objects.equals(value, EdeviceDiagnosisTypeEnum.XRAY_BREAST.value) || Objects.equals(value, EdeviceDiagnosisTypeEnum.XRAY_ORDINARY.value) || Objects.equals(value, EdeviceDiagnosisTypeEnum.XRAY_OTHER.value);
    }

    public static boolean isINTERVENTIONALForError(Integer value) {
        return Objects.equals(value, EdeviceDiagnosisTypeEnum.INTERVENTIONAL_DSA.value) || Objects.equals(value, EdeviceDiagnosisTypeEnum.INTERVENTIONAL_OTHER.value);
    }

    @Generated
    private EdeviceDiagnosisTypeEnum(Integer value, String name) {
        this.value = value;
        this.name = name;
    }

    @Generated
    public Integer getValue() {
        return this.value;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

