package cn.smarthse.rho.modules.sys.utils.risk;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.smarthse.rho.modules.sys.enums.RhoTimeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import lombok.extern.slf4j.Slf4j;

import javax.smarthse.framework.exception.ServiceException;
import java.time.Duration;
import java.time.LocalDateTime;

@Slf4j
public class WarningTypeUtil {
   public static Integer calculateNonDataWarningType(LocalDateTime time){
       if (time == null){
           throw new ServiceException("时间不能为空");
       }
       LocalDateTime now = LocalDateTime.now();
       Duration diffTime = LocalDateTimeUtil.between(now, time);
       long diffSeconds = diffTime.getSeconds();
       long abs = Math.abs(diffSeconds);
       int warnType = RiskWarningStatusEnum.NONE.getValue();

       if(diffSeconds > 0){//没过期
           warnType =  RiskWarningStatusEnum.NONE.getValue();
       }else {//过期
           if(abs < RhoTimeEnum.SECOND_OF_30_DAY.getTime()){
               warnType = RiskWarningStatusEnum.RED.getValue();
           }else {
               warnType = RiskWarningStatusEnum.ACTIVATE_LAW.getValue();
           }
       }
       return warnType;
   }

    public static Integer calculateHasDataWarningType(LocalDateTime now, LocalDateTime expireDate){
        Duration diffTime = LocalDateTimeUtil.between(now, expireDate);
        return calculateHasDataWarningType(diffTime.getSeconds());
    }
    private static Integer calculateHasDataWarningType(long diffTimes) {
        Integer warnType = RiskWarningStatusEnum.NONE.getValue();
        long abs = Math.abs(diffTimes);

        if(diffTimes > 0){//没过期
            if(RhoTimeEnum.SECOND_OF_90_DAY.getTime() < abs){
                warnType = RiskWarningStatusEnum.NONE.getValue();
            }else if(RhoTimeEnum.SECOND_OF_30_DAY.getTime() < abs && abs <= RhoTimeEnum.SECOND_OF_90_DAY.getTime()){
                warnType = RiskWarningStatusEnum.FIRST.getValue();
            }else if(abs <= RhoTimeEnum.SECOND_OF_30_DAY.getTime()){
                warnType = RiskWarningStatusEnum.YELLOW.getValue();
            }else {
                warnType = RiskWarningStatusEnum.NONE.getValue();
            }
        }else {//过期
            if(abs < RhoTimeEnum.SECOND_OF_30_DAY.getTime()){
                warnType = RiskWarningStatusEnum.RED.getValue();
            }else {
                warnType = RiskWarningStatusEnum.ACTIVATE_LAW.getValue();
            }
        }
        return warnType;
    }

    public static Integer calculateHasDataWarningTypeForCompanyCert(LocalDateTime now, LocalDateTime expireDate, Integer cycleYear) {
        if(cycleYear == null){
            return null;
        }
        Duration diffTime = LocalDateTimeUtil.between(now, expireDate);
        long diffTimes = diffTime.getSeconds();
        //周期为1年，没有首次预警
        if(cycleYear == 1 && diffTimes <= - RhoTimeEnum.SECOND_OF_30_DAY.getTime()){
            return RiskWarningStatusEnum.NONE.getValue();
        }

        return calculateHasDataWarningType(diffTimes);
    }

    public static Integer calculateHasDataWarningTypeForDose(LocalDateTime now, LocalDateTime expireDate) {
        Duration diffTime = LocalDateTimeUtil.between(now, expireDate);
        long diffTimes = diffTime.getSeconds();
        long abs = Math.abs(diffTimes);
        Integer warnType = warnType = RiskWarningStatusEnum.NONE.getValue();
        if(diffTimes > 0){//没过期
            if(abs <= RhoTimeEnum.SECOND_OF_30_DAY.getTime()){
                warnType = RiskWarningStatusEnum.YELLOW.getValue();
            }else {
                warnType = RiskWarningStatusEnum.NONE.getValue();
            }
        }else {//过期
            if(abs <= RhoTimeEnum.SECOND_OF_30_DAY.getTime()){
                warnType = RiskWarningStatusEnum.RED.getValue();
            }else {
                warnType = RiskWarningStatusEnum.ACTIVATE_LAW.getValue();
            }
        }
        return warnType;
    }
}
