package cn.smarthse.rho.modules.sys.utils.risk;

import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

/**
 * 风险日期工具
 */
public class RiskDateUtil implements Serializable {



    /**
     * 获取整改期限
     * @author chuhy
     * @date 2025/8/9 19:38
     */
    public static LocalDate calRequireFinishTime(LocalDate startTime, Integer riskType, Integer isGenByData, Integer healthSpecialWarning){

        // 性能、场所检测、个人防护用品、安全警示标识，有效期一年
        // 有检测日期, 超出有效期（检测日期加一年）的第30天。
        // 无检测日期，当前日期加30天。
        if (Objects.equals(riskType, RiskTypeEnum.PLACE_TEST.getValue())
                || Objects.equals(riskType, RiskTypeEnum.PERFORMANCE_TEST.getValue())){
            if (isGenByData == 0){
                return LocalDate.now().plusDays(30);
            } else {
                return startTime.plusYears(1).plusDays(30);
            }
        }
        // 防护用品、警示标识 特殊情况：退回操作后，有数据风险-> 变成无数据风险的情况：此时startTime = 上次有数据的风险的业务时间
        if (Objects.equals(riskType, RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue())
                || Objects.equals(riskType, RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue())){
            if (isGenByData == 0){
                return startTime != null ? startTime.plusYears(1).plusDays(30) : LocalDate.now().plusDays(30);
            } else {
                return startTime.plusYears(1).plusDays(30);
            }
        }

        // 培训，有效期为两年
        if (Objects.equals(riskType, RiskTypeEnum.TRAINING.getValue())){
            if (isGenByData == 0){
                return LocalDate.now().plusDays(30);
            } else {
                return startTime.plusYears(2).plusDays(30);
            }
        }

        // 体检，有效期为两年
        if (Objects.equals(riskType, RiskTypeEnum.PHYSICAL_EXAMINATION.getValue())){
            // 特殊，以上岗时间为准
            if (healthSpecialWarning == 1){
                return startTime.plusYears(2).plusDays(30);
            }
            if (isGenByData == 0){
                return LocalDate.now().plusDays(30);
            } else {
                return startTime.plusYears(2).plusDays(30);
            }
        }

        // 个人剂量监测，有效期为90天
        if (Objects.equals(riskType, RiskTypeEnum.DOSE_MONITORING.getValue())){
            if (isGenByData == 0){
                return LocalDate.now().plusDays(30);
            } else {
                return startTime.plusDays(90).plusDays(30);
            }
        }

        // 许可管理 todo 问需求有效期多久
        if (Objects.equals(riskType, RiskTypeEnum.LICENSE_MANAGEMENT.getValue())){
            if (isGenByData == 0){
                return LocalDate.now().plusDays(30);
            } else {
                return startTime.plusDays(30);
            }
        }


        // 异常
        // 发现异常直接为红色预警，所以默认为第30天
        if (Objects.equals(riskType, RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue())
                || Objects.equals(riskType, RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue())
                || Objects.equals(riskType, RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue())
                || Objects.equals(riskType, RiskTypeEnum.DOSE_EXCEPTION_OVERDOSE.getValue())){
            return LocalDate.now().plusDays(30);
        }
        // 检测异常，从黄色预警开始，所以第60天为红色预警的最后一天
        else if (Objects.equals(riskType, RiskTypeEnum.EXCEPTION_PERFORMANCE_TEST.getValue())
                || Objects.equals(riskType, RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue())){
            return LocalDate.now().plusDays(60);
        }


        return null;
    }
}
