package cn.smarthse.rho.modules.sys.utils.file;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;

import javax.smarthse.framework.exception.ServiceException;
import java.util.List;
import java.util.stream.Collectors;

public class FileXxsUtil {
    public static String excludeXxsFileName(String originalFilename){
        List<String> split = StrUtil.split(originalFilename,".");
        if(split.size() < 2){
            throw new ServiceException("文件名不合法！");
        }

        String fileNameExExt = split.stream().limit(Math.max(split.size() - 1, 0)).collect(Collectors.joining("-"));
        fileNameExExt = HtmlUtil.cleanHtmlTag(HtmlUtil.filter(fileNameExExt));
        if(StrUtil.isBlank(fileNameExExt)){
            throw new ServiceException("文件名不合法！");
        }

        String result = fileNameExExt + "." + split.get(split.size() - 1);
        return result;
    }
}
