package cn.smarthse.rho.modules.sys.utils.company;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.smarthse.rho.modules.sys.enums.RhoTimeEnum;
import cn.smarthse.rho.modules.sys.enums.company.CompanyCertCycleEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public class CompanyCertUtil {
    public static LocalDateTime calculateExpireDate(LocalDateTime beginDate, LocalDateTime lastVerificationDate, Integer cycleYear, int pushType){
        //没有上一次校验日期，那就模式是发证日期
        lastVerificationDate = lastVerificationDate == null ? beginDate : lastVerificationDate;

        //默认是上一次校验日期，因此非1就是上一次校验日期
        LocalDateTime startTime = pushType == 1 ? beginDate : lastVerificationDate;
        if(startTime == null){
            return null;
        }

        //推送方式以上一次校验日期为准，则直接在上一次推送日期上加一个周期
        if(pushType == 2){
            return LocalDateTimeUtil.offset(startTime, cycleYear, ChronoUnit.YEARS);
        }

        LocalDateTime endTime = lastVerificationDate;
        int diffYear = endTime.getYear() - startTime.getYear();
        if(diffYear < 0){
            return startTime;
        }

        // 1. 计算从开始日期到当前日期经过了多少个完整的周期
        long periodsElapsed = ChronoUnit.YEARS.between(startTime, endTime) / cycleYear;

        // 2. 计算当前周期开始的日期
        LocalDateTime currentPeriodStart = startTime.plusYears(periodsElapsed * cycleYear);

        // 3. 计算当前周期的结束日期 (开始日期 + 周期长度 - 1天)
        // 注意：周期的最后一天是 (开始日期 + n年 - 1天)
        // 例如，开始于2020-01-01，1年周期，则周期结束于2020-12-31
        LocalDateTime currentPeriodEnd = currentPeriodStart.plusYears(cycleYear);
        //先不减一了
//        currentPeriodEnd.minusDays(1);
        return currentPeriodEnd;
    }

    public static LocalDateTime calculateStartDate(Integer cycleYear,LocalDateTime expireTime) {
        LocalDateTime startTime = LocalDateTimeUtil.offset(expireTime, -cycleYear, ChronoUnit.YEARS);
        return startTime;
    }

    public static Integer calculateCycleYear(Integer companyType,Integer floorNum) {
        return CompanyCertCycleEnum.getCycle(String.valueOf(companyType), floorNum);
    }

    public static Integer calculateHasDataWarningTypeForCompanyCert(LocalDateTime now, LocalDateTime expireDate, Integer cycleYear) {
        Duration diffTime = LocalDateTimeUtil.between(now, expireDate);
        long diffTimes = diffTime.getSeconds();
        //周期为1年，没有首次预警
        if(cycleYear == 1 && diffTimes <= - RhoTimeEnum.SECOND_OF_30_DAY.getTime()){
            return RiskWarningStatusEnum.NONE.getValue();
        }

        return calculateHasDataWarningType(diffTimes);
    }

    public static Integer calculateHasDataWarningType(long diffTimes) {
        Integer warnType = RiskWarningStatusEnum.NONE.getValue();
        long abs = Math.abs(diffTimes);

        if(diffTimes > 0){//没过期
            if(RhoTimeEnum.SECOND_OF_90_DAY.getTime() < abs){
                warnType = RiskWarningStatusEnum.NONE.getValue();
            }else if(RhoTimeEnum.SECOND_OF_30_DAY.getTime() < abs && abs <= RhoTimeEnum.SECOND_OF_90_DAY.getTime()){
                warnType = RiskWarningStatusEnum.FIRST.getValue();
            }else if(abs <= RhoTimeEnum.SECOND_OF_30_DAY.getTime()){
                warnType = RiskWarningStatusEnum.YELLOW.getValue();
            }else {
                warnType = RiskWarningStatusEnum.NONE.getValue();
            }
        }else {//过期
            if(abs < RhoTimeEnum.SECOND_OF_30_DAY.getTime()){
                warnType = RiskWarningStatusEnum.RED.getValue();
            }else {
                warnType = RiskWarningStatusEnum.ACTIVATE_LAW.getValue();
            }
        }
        return warnType;
    }

}
