package cn.smarthse.rho.modules.sys.utils;


import cn.smarthse.rho.modules.sys.enums.staff.IdCardTypeEnum;

public class RhoIdCardBusinessUtil {

    /**
     * 身份证校验(只给需要做校验的类型进行校验，其他都返回true)
     * @param idcard
     * @param idcardType
     * @return
     */
    public static boolean checkIdcard(String idcard, String idcardType) {
        if(IdCardTypeEnum.ID_CARD.getValue().equals(idcardType)){
            return RhoIdCardUtil.isValid_CN_DL_IdCard18(idcard);
        }

        if(IdCardTypeEnum.ID_CARD_HK_MC_TW.getValue().equals(idcardType)){
            return RhoIdCardUtil.isValid_CN_HkMcTw_IdCard(idcard);
        }

        if(IdCardTypeEnum.ID_CARD_WXK.getValue().equals(idcardType)){
            return RhoIdCardUtil.isValid_CN_Wxk_IdCard(idcard);
        }

        if(idcardType.equals(IdCardTypeEnum.HK_MC_HOME_RETURN_PERMIT.getValue())){
            return RhoIdCardUtil.isValid_HkMc_RoundTripPermit(idcard);
        }

        if(idcardType.equals(IdCardTypeEnum.TW_HOME_RETURN_PERMIT.getValue())){
            return RhoIdCardUtil.isValid_Tw_RoundTripPermit(idcard);
        }

        return true;
    }
}
