package cn.smarthse.rho.modules.sys.provider.sys;

import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.PageParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysParamQueryParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysParamTypeVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysParamVo;

import java.util.List;

/**
 * 系统：系统参数
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2024/5/16 14:55
 */
public interface ISysParamProvider {

    /**
     * 查询指定类型的参数编码
     * @param type
     * @return {@link List<SysParamVo>}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/5/16 14:23
     */
    List<SysParamVo> getList(Long type);

    /**
     * 查询指定类型的参数编码(分页)
     * @Author ChenLiang
     * @Date 10:11 2024/6/19
     * @param param
     * @return LayuiGridData<SysParamVo>
     */
    LayuiGridData<SysParamVo> getPageList(SysParamQueryParam param);

    /**
     * 查询指定类型的参数编码
     * @param code
     * @return {@link SysParamVo}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/5/16 14:23
     */
    SysParamVo getParam(Integer code);

    /**
     * 查询指定类型的参数编码
     * @param code
     * @return {@link String}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/5/16 14:23
     */
    String getName(Integer code);
    /**
     * 查询参数类型列表
     * @param param
     * @return {@link List<SysParamTypeVo>}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/5/16 14:57
     */
    List<SysParamTypeVo> getParamTypeList(PageParam param);
}
