package cn.smarthse.rho.modules.sys.provider.sys;

import cn.smarthse.rho.modules.sys.entity.sys.SysFile;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;

import java.util.List;


/**
 *
 *  系统附件服务service
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/9 15:39
 */
public interface ISysFileProvider {

	/**
	 * 根据文件id查询文件详情
	 * @param fileId : 文件id
	 * @return SysFileModel
	 */
	SysFileVo getFileById(Long fileId);

	/**
	 * 根据ids 查询文件信息
	 * @param ids id有逗号隔开
	 * @return {@link List< SysFileVo >}
	 * @author liaoly
	 * @date 2022/3/18 9:34
	 */
	List<SysFileVo> getFileVoByIds(String ids);

	/**
	 * 根据文件hash值获取文件
	 * @param filehash : 文件hash值
	 * @return SysFileVo
	 */
	SysFileVo getFileByHash(String filehash);

	/**
	 * 根据文件Id获得文件全路径地址
	 * @param fileId : 文件id
	 * @return String
	 */
	String getFileUrl(Long fileId);

	/**
	 * 通用的文件上传接口
	 * @param record : 文件对象
	 * @param adminId : 操作账号id，可为空
	 * @return
	 */
	SysFileVo addSysFile(SysFile record, Long adminId);

}
