package cn.smarthse.rho.modules.sys.provider.sys;

import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.mybatis.SysChangeLog;
import cn.smarthse.rho.modules.sys.model.sys.param.SysChangeLogListParam;

import java.util.List;

/**
 * 系统通用接口
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/6/3 15:56
 */
public interface ISysCommonProvider {

    /**
     * 查询数据的变更日志
     *
     * @param dataId    数据id
     * @param tableName 数据表名 eg：b_company
     * @return {@link List<SysChangeLog>}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/6/3 15:59
     */
    List<SysChangeLog> getChangeLogList(Long dataId, String tableName);

    LayuiGridData<SysChangeLog> getChangeLogList(SysChangeLogListParam param);

    /**
     * 查询数据的变更日志（某个字段的）
     *
     * @param dataId     数据id
     * @param tableName  数据表名 eg：b_company
     * @param fieldValue 字段名英文 eg：name
     * @return {@link List<SysChangeLog>}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/6/3 15:59
     */
    List<SysChangeLog> getChangeLogList(Long dataId, String tableName, String fieldValue);

    /**
     * 查询数据的变更日志（多个字段）
     *
     * @param dataId      数据id
     * @param tableName   数据表名 eg：b_company
     * @param fieldValues 字段名英文 eg：name
     * @return {@link List<SysChangeLog>}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/6/3 15:59
     */
    List<SysChangeLog> getMultiFieldChangeLogList(Long dataId, String tableName, List<String> fieldValues);
}
