package cn.smarthse.rho.modules.sys.provider.risk;


import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.sys.entity.r.RRiskAcceptanceRecord;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.model.c.param.CheckOrgChooseQueryParam;
import cn.smarthse.rho.modules.sys.model.c.vo.ThirdOrgVo;
import cn.smarthse.rho.modules.sys.model.r.param.*;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskAcceptanceCommonVo;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskAcceptanceHistoryVo;

import java.util.List;

/**
 * 暴露接口 - 风险
 * @author chuhy
 * @date 2024/8/2 15:00
 */
public interface IRiskProvider {

    /**
     * 通用接口 - 生成风险
     * 生成规则：
     * 1.basic每个企业每年每个类型只有一条记录
     * 2.source和basic是一对多关系，一条basic会有多条source记录
     *
     * @author chuhy
     * @date 2024/7/29 15:21
     */
    void genRiskOfCommon(List<AddRiskForCommonParam> paramList);

    /**
     * 通用接口 - 化解风险
     *
     * @author chuhy
     * @date 2024/8/26 15:56
     */
    void resolveRiskOfCommon(List<Long> sourceIdList);

    /**
     * 通用接口 - 化解风险(new)
     * @author chuhy
     * @date 2025/9/1 9:36
     */
    void resolveRiskOfCommon(ResolveRiskForCommonParam param);

    /**
     * 变更source风险预警状态
     * @param param
     * @author chuhy
     * @date 2024/9/5 14:47
     */
    void searchAndChangeSourceRiskWarningStatus(RiskMangerGenParam param);

    /**
     * 变更basic风险预警状态
     * @param param
     * @author chuhy
     * @date 2024/9/10 16:14
     */
    void searchAndChangeBasicRiskWarningStatus(RiskMangerGenParam param);

    /**
     * 查找体检相关风险
     * @author chuhy
     * @date 2025/7/18 11:26
     */
    List<RRiskBasicSource> listRiskSourceAboutPhysical(SearchRiskParam param);

    /**
     * 保存风险验收记录历史
     * @author chuhy
     * @date 2025/7/18 11:26
     */
    void saveRiskAcceptanceRecordHistory(RRiskAcceptanceRecord riskAcceptanceRecord);
    void saveBatchRiskAcceptanceRecordHistory(List<RRiskAcceptanceRecord> RRiskAcceptanceRecordList);

    /**
     * 根据风险id，查询历史验收记录
     * @author chuhy
     * @date 2025/8/3 14:10
     */
    public LayuiGridData<RiskAcceptanceHistoryVo> listAcceptanceHistory(RiskQueryCommonParam param);

    /**
     * 根据sourceId，获取整改验收记录（包含当前正在进行的整改）
     * @author chuhy
     * @date 2025/8/7 16:47
     */
    List<RiskAcceptanceCommonVo> listAcceptanceRecordBySourceId(Long sourceId);

    /**
     * 获取检查机构选择列表(浙里卫企机构表)
     * @author wuxq
     * @date 2025/8/20 16:47
     */
    LayuiGridData<ThirdOrgVo> getCheckOrgChooseList(CheckOrgChooseQueryParam param);

    /**
     * 系统自动验收长生新的风险，获取历史整改数据
     * @author wuxq
     * @date 2025/8/20 16:47
     */
    RiskAcceptanceHistoryVo getHistoryAcceptRecord(Long sourceId);

    /**
     * 根据细分业务id删除风险及验收记录
     * ps: 目前有场所、设备会用到
     *
     * @author chuhy
     * @date 2025/12/17 17:36
     */
    void delRiskBySubBusinessId(Long cid, Long subBusinessId);
}
